/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.table.RowTableColumn;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.JRowTable;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.mf.common.license.ProductDecoder;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.TableColumn;

public class JProductDecoderDialog
extends JMADialog {
    private static final String RES_EVAL_MODE = "eval_mode";
    private static final String FEATURE_EVAL_MODE = "Evaluation Mode";
    JRowTable m_table;
    JCheckBox m_evalMode = new JCheckBox();
    ProductDecoder m_decoder = null;
    Boolean m_newEvalMode = null;
    Boolean m_oldEval = null;

    public JProductDecoderDialog(JMADialog parent, ProductDecoder decoder, Boolean oldEval) {
        super(parent, "product-decoder");
        this.m_decoder = decoder;
        this.m_oldEval = oldEval;
    }

    @Override
    public void maInitialize() {
        this.initUI();
        this.initForm();
    }

    @Override
    protected void maCleanup() {
        if (this.m_table != null) {
            this.m_table.cleanup();
        }
    }

    protected void initUI() {
        try {
            this.getContentPane().add(this.makeMainPanel());
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Unable to initialize the form", e, true);
        }
    }

    protected void initForm() {
        this.m_evalMode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JProductDecoderDialog.this.m_newEvalMode = new Boolean(JProductDecoderDialog.this.m_evalMode.isSelected());
            }
        });
        this.m_evalMode.setSelected(this.getFeatureEvaluationMode());
        if (this.m_oldEval != null) {
            this.m_evalMode.setSelected(this.m_oldEval);
        }
    }

    protected JPanel makeMainPanel() {
        JPartitionPanel panel = new JPartitionPanel(true, "r,p", null, 0, 0, 0);
        panel.add(this.makeFeaturesPanel());
        panel.add(this.makeProductInformationPanel());
        return panel;
    }

    private void insertRow(String name, Object value) {
        if (value != null && value instanceof String && ((String)value).startsWith("-1")) {
            value = "Unlimited";
        }
        int rowCount = this.m_table.getRowCount();
        ((IModelTableModel)this.m_table.getModel()).insertRow(new ProductEntry(name, value), rowCount);
    }

    protected JPanel makeFeaturesPanel() {
        JPartitionPanel panel = new JPartitionPanel(false, "r", "Features");
        TableColumn[] COLUMNS = new TableColumn[]{new ProductNameTableColumn(0, "Feature"), new ProductValueTableColumn(1, "Value")};
        this.m_table = new JRowTable(COLUMNS, this.getClass().getName());
        this.m_table.setPreferredScrollableViewportSize(new Dimension(COLUMNS[0].getPreferredWidth() + COLUMNS[1].getPreferredWidth(), 12 * this.m_table.getRowHeight()));
        this.insertRow("Control Number", this.m_decoder.getControlNumber());
        this.insertRow("Version", this.m_decoder.getVersion());
        this.insertRow("Product Name", this.m_decoder.getProductName());
        this.insertRow("Product Number", Integer.toString(this.m_decoder.getProductCode()));
        this.insertRow("Serial Number", Integer.toString(this.m_decoder.getSerialNumber()));
        String[] features = this.m_decoder.getFeatureList();
        for (int i = 0; i < features.length; ++i) {
            if (features[i].equals(FEATURE_EVAL_MODE)) continue;
            this.insertRow(features[i], this.m_decoder.getFeatureValue(features[i]));
        }
        ExtendedJScrollPane sp = new ExtendedJScrollPane(this.m_table);
        panel.add(sp);
        return panel;
    }

    private boolean getFeatureEvaluationMode() {
        String value = this.m_decoder.getFeatureValue(FEATURE_EVAL_MODE);
        return value == null || value.length() == 0 || value.equalsIgnoreCase("true");
    }

    protected JPanel makeProductInformationPanel() {
        JPartitionPanel panel = new JPartitionPanel("Control");
        panel.addRow(this.getResourceLabel(RES_EVAL_MODE), (JComponent)this.m_evalMode);
        return panel;
    }

    private String getResourceLabel(String name) {
        return ResourceManager.getString(this.getClass(), "dialog." + this.getTitleKey() + "." + name + ".label");
    }

    private JTextField initJTextField(JTextField field) {
        field.setBorder(null);
        field.setBackground(UIManager.getColor("Label.background"));
        field.setEditable(false);
        return field;
    }

    public Boolean isEvalMode() {
        return this.m_newEvalMode;
    }

    class ProductValueTableColumn
    extends RowTableColumn {
        public ProductValueTableColumn(int modelIndex, String title) {
            super(modelIndex, title, 40);
        }

        @Override
        public Object getColumnValue(Object rowModel) {
            return (String)((ProductEntry)rowModel).getValue();
        }
    }

    class ProductNameTableColumn
    extends RowTableColumn {
        public ProductNameTableColumn(int modelIndex, String title) {
            super(modelIndex, title, 60);
        }

        @Override
        public Object getColumnValue(Object rowModel) {
            return ((ProductEntry)rowModel).getFeature();
        }
    }

    class ProductEntry {
        private String m_feature;
        private Object m_value;

        public ProductEntry(String feature, Object value) {
            this.setProperties(feature, value);
        }

        private void setProperties(String feature, Object value) {
            this.setFeature(feature);
            this.setValue(value);
        }

        public void setFeature(String feature) {
            this.m_feature = feature;
        }

        public String getFeature() {
            return this.m_feature;
        }

        public void setValue(Object value) {
            this.m_value = value;
        }

        public Object getValue() {
            return this.m_value;
        }
    }
}

