/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.SwingWorker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class JProgressDialog
extends JDialog {
    private SwingWorker m_worker;
    private JButton m_btnCancel;
    private JProgressBar m_bar = new JProgressBar();

    public JProgressDialog(JMADialog parent, String title, boolean modal) {
        super(parent, title, modal);
    }

    public JProgressDialog(JMAFrame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.prepareJProgressDialog();
    }

    private void prepareJProgressDialog() {
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ect) {
                JProgressDialog.this.doCancel();
            }
        });
        this.m_bar.setIndeterminate(true);
        this.m_btnCancel = new JButton("Cancel");
        this.m_btnCancel.setDefaultCapable(true);
        this.m_btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JProgressDialog.this.doCancel();
            }
        });
        JPartitionPanel btnPanel = JPartitionPanel.merge("r,p,r", false, new Component[]{new JPanel(), this.m_btnCancel, new JPanel()});
        JPartitionPanel bottom = JPartitionPanel.merge("p,p", true, new Component[]{this.m_bar, btnPanel});
        this.getContentPane().add((Component)bottom, "South");
        this.pack();
        this.setLocation(this.getCenteredLocation());
    }

    public JProgressBar getProgressBar() {
        return this.m_bar;
    }

    public JButton getCancelButton() {
        return this.m_btnCancel;
    }

    public void setWorker(SwingWorker worker) {
        this.m_worker = worker;
    }

    public void setContent(JComponent content) {
        this.getContentPane().add((Component)JPartitionPanel.wrap(content), "Center");
        this.pack();
    }

    @Override
    public void setVisible(boolean state) {
        if (state) {
            this.m_worker.start();
        }
        super.setVisible(state);
    }

    private void doCancel() {
        try {
            if (this.m_worker != null) {
                this.m_worker.interrupt();
            }
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Error performing cancel operation.", e, true);
        }
    }

    private Point getCenteredLocation() {
        Point pLoc = this.getParent().getLocation();
        Dimension pSize = this.getParent().getSize();
        Dimension cSize = this.getPreferredSize();
        return new Point(pLoc.x + (pSize.width - cSize.width) / 2, pLoc.y + (pSize.height - cSize.height) / 2);
    }
}

