/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.PreferenceManager;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.table.ModelListTableModel;
import com.sonicsw.ma.gui.table.PluginNameTableCellRenderer;
import com.sonicsw.ma.gui.table.RowTableColumn;
import com.sonicsw.ma.gui.util.ExtendedJTable;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.PopupMenuShower;
import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JRowTable
extends ExtendedJTable {
    private boolean m_focusLossTemporary = false;
    private FocusListener m_focusListener = null;
    private String m_strPreferenceKey = null;
    private boolean m_bRealized = false;

    public JRowTable(TableColumn[] tableColumn, String strPreferenceKey) {
        this(new ModelListTableModel(tableColumn, new ArrayList()), strPreferenceKey);
    }

    public JRowTable(IModelTableModel tableModel, String strPreferenceKey) {
        this(tableModel, null, null, strPreferenceKey);
    }

    public JRowTable(IModelTableModel dm, TableColumnModel cm, ListSelectionModel sm, String strPreferenceKey) {
        super(dm, cm, sm);
        this.prepareJRowTable(strPreferenceKey);
    }

    private void prepareJRowTable(String strPreferenceKey) {
        this.m_strPreferenceKey = strPreferenceKey;
        this.setAutoCreateColumnsFromModel(false);
        this.getTableHeader().addMouseListener(new TableSorter(this));
        this.getTableHeader().addMouseListener(new PopupMenuShower(this, this.createHeaderPopupMenu()));
        this.getColumnModel().addColumnModelListener((TableColumnModelListener)((Object)this.getModel()));
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(false);
        ExtendedJTable.ExtendedTableCellRenderer leftR = new ExtendedJTable.ExtendedTableCellRenderer(2);
        ExtendedJTable.ExtendedTableCellRenderer rightR = new ExtendedJTable.ExtendedTableCellRenderer(4);
        this.setDefaultRenderer(Object.class, leftR);
        this.setDefaultRenderer(String.class, leftR);
        this.setDefaultRenderer(Boolean.class, leftR);
        this.setDefaultRenderer(Number.class, rightR);
        this.setDefaultRenderer(Double.class, rightR);
        this.setDefaultRenderer(Long.class, rightR);
        this.setDefaultRenderer(Integer.class, rightR);
        this.setAutoResizeMode(0);
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                if (!JRowTable.this.m_bRealized) {
                    Helper.invoke(new Runnable(){

                        @Override
                        public void run() {
                            JRowTable.this.loadColumnPrefs();
                        }
                    });
                    if (JRowTable.this.m_focusListener == null) {
                        JRowTable.this.m_focusListener = new FocusHandler();
                    }
                    JRowTable.this.addFocusListener(JRowTable.this.m_focusListener);
                    JRowTable.this.m_bRealized = true;
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    public boolean getSortable() {
        return ((IModelTableModel)this.getModel()).isSortActivated();
    }

    public void setSortable(boolean bSortable) {
        ((IModelTableModel)this.getModel()).activateSort(bSortable);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Object rowModel;
        Point point = event.getPoint();
        int rowIndex = this.rowAtPoint(point);
        int colIndex = this.columnAtPoint(point);
        int realColumnIndex = this.convertColumnIndexToModel(colIndex);
        TableCellRenderer renderer = this.getColumnModel().getColumn(realColumnIndex).getCellRenderer();
        if (renderer instanceof PluginNameTableCellRenderer && (rowModel = ((ModelListTableModel)this.getModel()).getRowModel(rowIndex)) instanceof AbstractGUIPlugin) {
            return ((AbstractGUIPlugin)rowModel).getToolTipText();
        }
        return super.getToolTipText(event);
    }

    public void cleanup() {
        this.saveColumnPrefs();
    }

    @Override
    protected TableColumnModel createDefaultColumnModel() {
        return new ExtendedTableColumnModel();
    }

    @Override
    public void createDefaultColumnsFromModel() {
        IModelTableModel tableModel = (IModelTableModel)this.getModel();
        if (tableModel != null) {
            ExtendedTableColumnModel cm = (ExtendedTableColumnModel)this.getColumnModel();
            cm.dropAllColumns();
            for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                TableColumn column = tableModel.getColumn(i);
                column.setHeaderRenderer(new HeaderCellRenderer(tableModel, column));
                this.addColumn(column);
            }
        }
    }

    @Override
    public void setModel(TableModel dm) {
        if (dm != null && !(dm instanceof IModelTableModel)) {
            throw new IllegalArgumentException("TableModel must extend IModelTableModel");
        }
        super.setModel(dm);
    }

    public void loadColumnPrefs() {
        int nWidthTable;
        boolean bChanged = false;
        ExtendedTableColumnModel modelColumn = (ExtendedTableColumnModel)this.getColumnModel();
        IModelTableModel modelTable = (IModelTableModel)this.getModel();
        if (this.m_strPreferenceKey != null && modelTable != null && modelColumn != null) {
            modelTable.setSortedByColumn(PreferenceManager.getInstance().getInt("table", this.m_strPreferenceKey + ".sortColumn", 0), PreferenceManager.getInstance().getBoolean("table", this.m_strPreferenceKey + ".sortAscending", modelTable.isSortedInAscendingOrder()));
            int nCols = modelColumn.getWrappedColumnCount();
            for (int nCol = 0; nCol < nCols; ++nCol) {
                WrappedColumn wCol;
                TableColumn col;
                int nPreferredWidth = PreferenceManager.getInstance().getInt("table", this.m_strPreferenceKey + "." + modelColumn.getWrappedColumnName(nCol) + ".width", -1);
                if (nPreferredWidth != -1) {
                    modelTable.getColumn(nCol).setPreferredWidth(nPreferredWidth);
                    bChanged = true;
                }
                boolean defVisible = (col = (wCol = modelColumn.getWrappedColumn(nCol)).getTableColumn()) instanceof RowTableColumn ? ((RowTableColumn)col).isDefaultVisible() : true;
                boolean bVisible = PreferenceManager.getInstance().getBoolean("table", this.m_strPreferenceKey + "." + modelColumn.getWrappedColumnName(nCol) + ".visible", defVisible);
                if (!bVisible) {
                    modelColumn.removeColumn(col);
                    continue;
                }
                if (wCol.isVisible()) continue;
                modelColumn.addColumn(col);
            }
        }
        if (!bChanged && (nWidthTable = this.getViewportWidth()) != 0 && !this.sizeColumnsToPreferredWidths(nWidthTable)) {
            this.sizeColumnsToTableWidth();
        }
    }

    protected void saveColumnPrefs() {
        if (!this.m_bRealized) {
            return;
        }
        ExtendedTableColumnModel modelColumn = (ExtendedTableColumnModel)this.getColumnModel();
        if (this.m_strPreferenceKey != null && modelColumn != null) {
            IModelTableModel modelTable = (IModelTableModel)this.getModel();
            PreferenceManager.getInstance().setInt("table", this.m_strPreferenceKey + ".sortColumn", modelTable.getSortColumn(), false);
            PreferenceManager.getInstance().setBoolean("table", this.m_strPreferenceKey + ".sortAscending", modelTable.isSortedInAscendingOrder(), false);
            int nCols = modelColumn.getWrappedColumnCount();
            for (int nCol = 0; nCol < nCols; ++nCol) {
                TableColumn col = modelColumn.getWrappedColumn(nCol).getTableColumn();
                if (col == null) continue;
                PreferenceManager.getInstance().setInt("table", this.m_strPreferenceKey + "." + modelColumn.getWrappedColumnName(nCol) + ".width", col.getWidth(), false);
                ExtendedTableColumnModel model = (ExtendedTableColumnModel)this.getColumnModel();
                boolean bVisible = model.isColumnVisible(col);
                PreferenceManager.getInstance().setBoolean("table", this.m_strPreferenceKey + "." + modelColumn.getWrappedColumnName(nCol) + ".visible", bVisible, false);
            }
            PreferenceManager.getInstance().flush("table");
        }
    }

    public void sizeColumnsToTableWidth() {
        int nWidthTable;
        int remainder = nWidthTable = this.getViewportWidth();
        if (nWidthTable != 0) {
            ExtendedTableColumnModel extModel = (ExtendedTableColumnModel)this.getColumnModel();
            for (int k = 0; k < extModel.getWrappedColumnCount(); ++k) {
                WrappedColumn columnModel = extModel.getWrappedColumn(k);
                if (!columnModel.isVisible()) continue;
                int columnWidth = Math.round(nWidthTable / extModel.getColumnCount());
                remainder -= columnWidth;
                if (k == extModel.getWrappedColumnCount() - 1) {
                    columnWidth += remainder;
                }
                columnModel.getTableColumn().setPreferredWidth(columnWidth);
            }
        }
    }

    public boolean sizeColumnsToPreferredWidths(int nWidthTable) {
        boolean bSized = false;
        if (nWidthTable > 0) {
            ExtendedTableColumnModel extModel = (ExtendedTableColumnModel)this.getColumnModel();
            for (int k = 0; k < extModel.getWrappedColumnCount(); ++k) {
                WrappedColumn columnModel = extModel.getWrappedColumn(k);
                TableColumn col = columnModel.getTableColumn();
                if (col.getPreferredWidth() == -1) continue;
                col.setPreferredWidth((int)Math.round((double)nWidthTable * ((double)col.getPreferredWidth() * 0.01)));
                bSized = true;
            }
        }
        return bSized;
    }

    protected JPopupMenu createHeaderPopupMenu() {
        TableColumnModel model = this.getColumnModel();
        final JPopupMenu pm = new JPopupMenu("header-popupmenu");
        pm.add(new ColumnResetAction());
        pm.addSeparator();
        pm.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                for (int i = 0; i < pm.getComponentCount(); ++i) {
                    TableAction action;
                    Component item = pm.getComponent(i);
                    if (!(item instanceof AbstractButton) || (action = (TableAction)((AbstractButton)item).getAction()) == null) continue;
                    item.setEnabled(action.isEnabled());
                    if (!(item instanceof JCheckBoxMenuItem)) continue;
                    ((JCheckBoxMenuItem)item).setSelected(action.isSelected());
                }
            }
        });
        ExtendedTableColumnModel extModel = (ExtendedTableColumnModel)this.getColumnModel();
        for (int k = 0; k < extModel.getWrappedColumnCount(); ++k) {
            WrappedColumn columnModel = extModel.getWrappedColumn(k);
            ColumnKeeperAction action = new ColumnKeeperAction(columnModel.getTableColumn().getIdentifier(), columnModel.getTableColumn().getHeaderValue());
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
            item.setSelected(columnModel.isVisible());
            pm.add(item);
        }
        pm.addSeparator();
        ColumnFillAction action = new ColumnFillAction();
        pm.add(new JMenuItem(action));
        return pm;
    }

    private int limit(int i, int a, int b) {
        return Math.min(b, Math.max(i, a));
    }

    public boolean isFocusLossTemporary() {
        return this.m_focusLossTemporary;
    }

    class TableSorter
    extends MouseAdapter {
        private ExtendedJTable table;
        private boolean popupTrigger;

        public TableSorter(ExtendedJTable table) {
            this.table = table;
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.popupTrigger = event.isPopupTrigger();
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.popupTrigger = event.isPopupTrigger();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseClicked(MouseEvent event) {
            if (this.popupTrigger || event.getClickCount() != 1) {
                return;
            }
            IModelTableModel dm = (IModelTableModel)this.table.getModel();
            TableColumnModel cm = this.table.getColumnModel();
            int viewColumn = cm.getColumnIndexAtX(event.getX());
            int modelColumn = this.table.convertColumnIndexToModel(viewColumn);
            if (modelColumn != -1) {
                Object[] selectedObjects = this.getSelectedObjects(dm);
                try {
                    this.table.getSelectionModel().setValueIsAdjusting(true);
                    this.table.clearSelection();
                    dm.sortByColumn(modelColumn);
                    this.restoreObjectSelection(selectedObjects, dm);
                }
                finally {
                    this.table.getSelectionModel().setValueIsAdjusting(false);
                }
                this.table.getTableHeader().repaint();
            }
        }

        protected Object[] getSelectedObjects(IModelTableModel tableModel) {
            int[] selectedRows = this.table.getSelectedRows();
            int num = selectedRows.length;
            Object[] selectedObjects = new Object[num];
            for (int i = 0; i < num; ++i) {
                selectedObjects[i] = tableModel.getRowModel(selectedRows[i]);
            }
            return selectedObjects;
        }

        protected void restoreObjectSelection(Object[] selectedObjects, IModelTableModel tableModel) {
            for (Object obj : selectedObjects) {
                int row;
                int n = row = obj == null ? -1 : tableModel.getIndexOf(obj);
                if (row < 0) continue;
                this.table.getSelectionModel().setValueIsAdjusting(true);
                this.table.addRowSelectionInterval(row, row);
            }
        }
    }

    private class TableArrowIcon
    implements Icon {
        private boolean m_isAscending;

        TableArrowIcon(boolean isAscending) {
            this.m_isAscending = isAscending;
        }

        @Override
        public int getIconHeight() {
            return 5;
        }

        @Override
        public int getIconWidth() {
            return 9;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.m_isAscending) {
                this.paintIconAscending(g, x, y);
            } else {
                this.paintIconDescending(g, x, y);
            }
        }

        private void paintIconAscending(Graphics g, int x, int y) {
            g.setColor((Color)UIManager.getDefaults().get("infoText"));
            g.drawLine(x, y + 3, x + 3, y);
            g.drawLine(x + 4, y, x + 4, y);
            g.setColor((Color)UIManager.getDefaults().get("controlDkShadow"));
            g.drawLine(x + 3, y + 1, x + 5, y + 1);
            g.drawLine(x + 2, y + 2, x + 6, y + 2);
            g.drawLine(x + 1, y + 3, x + 7, y + 3);
            g.setColor((Color)UIManager.getDefaults().get("controlLtHighlight"));
            g.drawLine(x + 1, y + 4, x + 8, y + 4);
        }

        private void paintIconDescending(Graphics g, int x, int y) {
            g.setColor((Color)UIManager.getDefaults().get("infoText"));
            g.drawLine(x, y, x + 7, y);
            g.setColor((Color)UIManager.getDefaults().get("controlDkShadow"));
            g.drawLine(x + 1, y + 1, x + 6, y + 1);
            g.drawLine(x + 2, y + 2, x + 5, y + 2);
            g.drawLine(x + 3, y + 3, x + 4, y + 3);
            g.setColor((Color)UIManager.getDefaults().get("controlLtHighlight"));
            g.drawLine(x + 7, y + 1, x + 4, y + 4);
        }
    }

    private class HeaderCellRenderer
    extends ExtendedJTable.ExtendedTableHeaderRenderer {
        private Icon m_iconAscend;
        private Icon m_iconDescend;
        private IModelTableModel m_tableModel;
        private TableColumn m_tableColumn;
        private boolean m_bColumnSortable = false;

        HeaderCellRenderer(IModelTableModel tableModel, TableColumn tableColumn) {
            this.m_tableModel = tableModel;
            this.m_tableColumn = tableColumn;
            this.m_iconAscend = new TableArrowIcon(true);
            this.m_iconDescend = new TableArrowIcon(false);
            this.m_bColumnSortable = tableColumn instanceof RowTableColumn && ((RowTableColumn)tableColumn).isSortable();
            this.setProperties();
        }

        private void setProperties() {
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(10);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header;
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (table != null && (header = table.getTableHeader()) != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
            this.setText(value == null ? "" : value.toString());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return c;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            g.setColor(this.getForeground());
            if (this.m_bColumnSortable && this.m_tableModel.isSortActivated()) {
                TableColumn colSort;
                int sortColumn = this.m_tableModel.getSortColumn();
                if (sortColumn >= 0 && (colSort = this.m_tableModel.getColumn(sortColumn)) == this.m_tableColumn) {
                    Dimension size = this.getSize();
                    Icon icon = this.m_tableModel.isSortedInAscendingOrder() ? this.m_iconAscend : this.m_iconDescend;
                    icon.paintIcon(this, g, size.width - icon.getIconWidth() - 4, (size.height - icon.getIconHeight() - 2) / 2);
                    return;
                }
                this.setIcon(null);
            }
        }
    }

    private class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        private void updateForFocus() {
            JRowTable table = JRowTable.this;
            int[] sel = table.getSelectedRows();
            if (sel != null && sel.length > 0) {
                for (int i = 0; i < sel.length; ++i) {
                    Rectangle r = table.getCellRect(sel[i], -1, true);
                    r.width = table.getWidth();
                    table.repaint(r);
                }
            }
        }

        @Override
        public void focusGained(FocusEvent evt) {
            this.updateForFocus();
        }

        @Override
        public void focusLost(FocusEvent evt) {
            JRowTable.this.m_focusLossTemporary = evt.isTemporary() && evt.getOppositeComponent() != null;
            this.updateForFocus();
        }
    }

    class WrappedColumn {
        private TableColumn m_column;
        private boolean m_visible;
        private int m_initialPosition = -1;

        public WrappedColumn(TableColumn column) {
            this(column, true);
        }

        public WrappedColumn(TableColumn column, boolean visible) {
            this.m_column = column;
            this.m_visible = visible;
        }

        public TableColumn getTableColumn() {
            return this.m_column;
        }

        public void setVisible(boolean visible) {
            this.m_visible = visible;
        }

        public boolean isVisible() {
            return this.m_visible;
        }

        public int getInitialPosition() {
            return this.m_initialPosition;
        }

        public void setInitialPosition(int initialPosition) {
            if (this.m_initialPosition == -1) {
                this.m_initialPosition = initialPosition;
            }
        }
    }

    class ExtendedTableColumnModel
    extends DefaultTableColumnModel {
        private Vector m_all = new Vector();

        public int getWrappedColumnCount() {
            return this.m_all.size();
        }

        public String getWrappedColumnName(int nCol) {
            String strName = null;
            if (nCol < this.m_all.size()) {
                strName = (String)((WrappedColumn)this.m_all.get(nCol)).getTableColumn().getHeaderValue();
            }
            return strName;
        }

        public void dropAllColumns() {
            while (this.getColumnCount() > 0) {
                this.removeColumn(this.getColumn(0));
            }
            this.m_all.clear();
        }

        public WrappedColumn getWrappedColumn(int nCol) {
            WrappedColumn col = null;
            if (nCol < this.m_all.size()) {
                col = (WrappedColumn)this.m_all.get(nCol);
            }
            return col;
        }

        @Override
        public void addColumn(TableColumn column) {
            int index = this.findWrappedColumn(column);
            WrappedColumn wc = index >= 0 ? (WrappedColumn)this.m_all.get(index) : null;
            boolean add = false;
            if (wc == null) {
                wc = new WrappedColumn(column);
                this.m_all.add(wc);
                wc.setInitialPosition(this.m_all.indexOf(wc));
                add = true;
            } else if (!wc.isVisible()) {
                add = true;
                wc.setVisible(true);
            }
            if (add) {
                WrappedColumn tmpWC;
                int insertIndex = 0;
                for (int i = 0; i < this.m_all.size() && (tmpWC = (WrappedColumn)this.m_all.get(i)).getTableColumn() != column; ++i) {
                    if (!tmpWC.isVisible()) continue;
                    ++insertIndex;
                }
                super.addColumn(column);
                super.moveColumn(this.getColumnCount() - 1, insertIndex);
            }
        }

        @Override
        public void removeColumn(TableColumn column) {
            WrappedColumn wc;
            int index = this.findWrappedColumn(column);
            WrappedColumn wrappedColumn = wc = index >= 0 ? (WrappedColumn)this.m_all.get(index) : null;
            if (wc != null && wc.isVisible()) {
                wc.setVisible(false);
                super.removeColumn(column);
            }
        }

        @Override
        public void moveColumn(int columnIndex, int newIndex) {
            WrappedColumn wc;
            if (columnIndex != newIndex && (wc = (WrappedColumn)this.m_all.remove(columnIndex)) != null) {
                this.m_all.add(newIndex, wc);
            }
            super.moveColumn(columnIndex, newIndex);
        }

        public void resetToDefaults() {
            for (int i = 0; i < this.m_all.size(); ++i) {
                WrappedColumn wc = (WrappedColumn)this.m_all.get(i);
                this.addColumn(wc.getTableColumn());
            }
            WrappedColumn[] tmp = this.m_all.toArray(new WrappedColumn[this.m_all.size()]);
            for (int j = 0; j < tmp.length; ++j) {
                WrappedColumn wc = tmp[j];
                int initialPosition = wc.getInitialPosition();
                int currentPosition = this.getColumnIndex(wc.getTableColumn().getIdentifier());
                if (currentPosition == initialPosition) continue;
                this.moveColumn(currentPosition, initialPosition);
            }
        }

        private int findWrappedColumn(TableColumn column) {
            for (int i = 0; i < this.m_all.size(); ++i) {
                WrappedColumn wc = (WrappedColumn)this.m_all.get(i);
                if (wc.getTableColumn() != column) continue;
                return i;
            }
            return -1;
        }

        public boolean isColumnVisible(TableColumn column) {
            int i = this.findWrappedColumn(column);
            WrappedColumn wc = i >= 0 ? (WrappedColumn)this.m_all.get(i) : null;
            return wc != null ? wc.isVisible() : false;
        }

        public TableColumn getTableColumnExt(Object identifier) {
            for (int i = 0; i < this.m_all.size(); ++i) {
                WrappedColumn wc = (WrappedColumn)this.m_all.get(i);
                if (wc.getTableColumn().getIdentifier() != identifier) continue;
                return wc.getTableColumn();
            }
            return null;
        }

        public boolean isDefaulted() {
            for (int i = 0; i < this.m_all.size(); ++i) {
                WrappedColumn wc = (WrappedColumn)this.m_all.get(i);
                if (wc.isVisible() && wc.getInitialPosition() == i) continue;
                return false;
            }
            return true;
        }

        private String debug() {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.m_all.size(); ++i) {
                WrappedColumn wc = (WrappedColumn)this.m_all.get(i);
                if (i > 0) {
                    sb.append(", ");
                }
                if (!wc.isVisible()) {
                    sb.append("*");
                }
                sb.append(wc.getTableColumn().getHeaderValue());
                sb.append("(").append(wc.getInitialPosition()).append(")");
            }
            return sb.toString();
        }
    }

    class ColumnFillAction
    extends TableAction {
        public ColumnFillAction() {
            super("Fill");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JRowTable.this.sizeColumnsToTableWidth();
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    class ColumnResetAction
    extends TableAction {
        public ColumnResetAction() {
            super("View All Columns");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ExtendedTableColumnModel model = (ExtendedTableColumnModel)JRowTable.this.getColumnModel();
            model.resetToDefaults();
        }

        @Override
        public boolean isEnabled() {
            ExtendedTableColumnModel model = (ExtendedTableColumnModel)JRowTable.this.getColumnModel();
            return !model.isDefaulted();
        }
    }

    class ColumnKeeperAction
    extends TableAction {
        protected Object m_identifier;

        public ColumnKeeperAction(Object identifier, Object headerValue) {
            super(headerValue.toString());
            this.m_identifier = identifier;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)evt.getSource();
            ExtendedTableColumnModel model = (ExtendedTableColumnModel)JRowTable.this.getColumnModel();
            TableColumn column = model.getTableColumnExt(this.m_identifier);
            if (item.isSelected()) {
                model.addColumn(column);
            } else {
                model.removeColumn(column);
            }
            JRowTable.this.tableChanged(new TableModelEvent(JRowTable.this.getModel(), -1));
            JRowTable.this.repaint();
        }

        @Override
        public boolean isSelected() {
            ExtendedTableColumnModel model = (ExtendedTableColumnModel)JRowTable.this.getColumnModel();
            TableColumn column = model.getTableColumnExt(this.m_identifier);
            return model.isColumnVisible(column);
        }

        @Override
        public boolean isEnabled() {
            ExtendedTableColumnModel model = (ExtendedTableColumnModel)JRowTable.this.getColumnModel();
            TableColumn column = model.getTableColumnExt(this.m_identifier);
            return model.getColumnCount() != 1 || !model.isColumnVisible(column);
        }
    }

    class TableAction
    extends AbstractAction {
        public TableAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
        }

        public boolean isSelected() {
            return false;
        }
    }
}

