/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.BasicResourceAction;
import com.sonicsw.ma.gui.util.JButtonPanel;
import com.sonicsw.ma.gui.util.JRowTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class JRowTableButtonPanel
extends JButtonPanel
implements ListSelectionListener,
DocumentListener {
    private static final String CMD_ADD = "JRowTableButtonPanel.add";
    private static final String CMD_EDIT = "JRowTableButtonPanel.edit";
    private static final String CMD_REMOVE = "JRowTableButtonPanel.remove";
    private boolean m_activateTableSelection = true;
    private JRowTable m_table;
    private JButton m_add = null;
    private JButton m_edit = null;
    private JButton m_del = null;
    private boolean m_selDependent = true;

    public JRowTableButtonPanel(JRowTable table) {
        this(table, true);
    }

    public JRowTableButtonPanel(JRowTable table, boolean autoEdit) {
        this(table, autoEdit, 5, 0, 0);
    }

    public JRowTableButtonPanel(JRowTable table, int gapSize, int tbEdgeGap, int lrEdgeGap) {
        this(table, true, gapSize, tbEdgeGap, lrEdgeGap);
    }

    public JRowTableButtonPanel(JRowTable table, boolean autoEdit, int gapSize, int tbEdgeGap, int lrEdgeGap) {
        super(true, gapSize, tbEdgeGap, lrEdgeGap);
        this.m_table = table;
        this.m_table.getSelectionModel().addListSelectionListener(this);
        if (autoEdit) {
            this.m_table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (!JRowTableButtonPanel.this.m_activateTableSelection) {
                        return;
                    }
                    if (JRowTableButtonPanel.this.getEditAction() == null) {
                        return;
                    }
                    JRowTable table = (JRowTable)evt.getSource();
                    if (evt.getClickCount() == 2 && table.getSelectedRowCount() == 1) {
                        JRowTableButtonPanel.this.getEditAction().actionPerformed(null);
                    }
                }
            });
        }
        this.m_table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent evt) {
                if (!JRowTableButtonPanel.this.m_activateTableSelection) {
                    return;
                }
                JRowTableButtonPanel.this.updateSelectionModelState();
            }
        });
        this.setRemoveAction(new RemoveAction());
        this.updateState(table != null ? table.getSelectionModel() : null);
    }

    private void updateSelectionModelState() {
        this.updateState(this.m_table.getSelectionModel());
    }

    protected JRowTable getTable() {
        return this.m_table;
    }

    public Action getAddAction() {
        return this.getButton(JAddButton.class) != null ? this.getButton(JAddButton.class).getAction() : null;
    }

    public final Action getEditAction() {
        return this.getButton(JEditButton.class) != null ? this.getButton(JEditButton.class).getAction() : null;
    }

    public Action getRemoveAction() {
        return this.getButton(JRemoveButton.class) != null ? this.getButton(JRemoveButton.class).getAction() : null;
    }

    public void setAddAction(BasicResourceAction action) {
        JButton btn = this.getButton(JAddButton.class);
        if (btn != null) {
            btn.setAction(action);
        } else {
            this.add((Component)new JAddButton(action), 0);
        }
        this.updateState(null);
    }

    public void setEditAction(BasicResourceAction action) {
        JButton btn = this.getButton(JEditButton.class);
        if (btn != null) {
            btn.setAction(action);
        } else {
            int insertIndex = this.getButton(JAddButton.class) != null ? 1 : 0;
            this.add((Component)new JEditButton(action), insertIndex);
        }
        this.updateState(null);
    }

    public final void setRemoveAction(BasicResourceAction action) {
        JButton btn = this.getButton(JRemoveButton.class);
        if (btn != null) {
            btn.setAction(action);
        } else {
            this.add(new JRemoveButton(action));
        }
        this.updateState(null);
    }

    public void setSelectionDependent(boolean state) {
        this.m_selDependent = state;
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (this.m_selDependent && this.m_activateTableSelection) {
            this.updateState((ListSelectionModel)evt.getSource());
        }
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
        this.updateState(this.m_table.getSelectionModel());
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        this.updateState(this.m_table.getSelectionModel());
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        this.updateState(this.m_table.getSelectionModel());
    }

    public void enableComponent(boolean state) {
        this.m_activateTableSelection = state;
        this.m_table.setEnabled(state);
        this.m_table.setSortable(state);
        if (state) {
            this.updateState(this.m_table.getSelectionModel());
        } else {
            this.getAddAction().setEnabled(false);
            this.getEditAction().setEnabled(false);
            this.getRemoveAction().setEnabled(false);
        }
    }

    protected void updateState(ListSelectionModel selModel) {
        int selCount;
        if (!this.m_activateTableSelection) {
            return;
        }
        int n = selCount = selModel != null ? this.getSelectedRowCount(selModel) : 0;
        if (this.getAddAction() != null) {
            this.getAddAction().setEnabled(true);
        }
        if (this.getEditAction() != null) {
            this.getEditAction().setEnabled(this.m_selDependent ? selCount == 1 : true);
        }
        if (this.getRemoveAction() != null) {
            this.getRemoveAction().setEnabled(selCount > 0);
        }
    }

    protected int getSelectedRowCount(ListSelectionModel selModel) {
        int iMin = selModel.getMinSelectionIndex();
        int iMax = selModel.getMaxSelectionIndex();
        int count = 0;
        for (int i = iMin; i <= iMax; ++i) {
            if (!selModel.isSelectedIndex(i)) continue;
            ++count;
        }
        return count;
    }

    class RemoveAction
    extends BasicGuiAction {
        RemoveAction() {
            super(JRowTableButtonPanel.CMD_REMOVE);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                int[] selRow = JRowTableButtonPanel.this.m_table.getSelectedRows();
                for (int i = selRow.length - 1; i >= 0; --i) {
                    if (!JRowTableButtonPanel.this.m_table.getSelectionModel().isSelectedIndex(selRow[i]) || selRow[i] >= JRowTableButtonPanel.this.m_table.getRowCount()) continue;
                    ((IModelTableModel)JRowTableButtonPanel.this.m_table.getModel()).deleteRow(selRow[i]);
                }
                int anchorIndex = JRowTableButtonPanel.this.m_table.getSelectionModel().getAnchorSelectionIndex();
                if (JRowTableButtonPanel.this.m_table.getRowCount() == 0) {
                    JRowTableButtonPanel.this.updateState(null);
                }
                if (anchorIndex < JRowTableButtonPanel.this.m_table.getRowCount()) {
                    JRowTableButtonPanel.this.m_table.getSelectionModel().setSelectionInterval(anchorIndex, anchorIndex);
                } else if (JRowTableButtonPanel.this.m_table.getRowCount() > 0) {
                    JRowTableButtonPanel.this.m_table.getSelectionModel().setSelectionInterval(JRowTableButtonPanel.this.m_table.getRowCount() - 1, JRowTableButtonPanel.this.m_table.getRowCount() - 1);
                }
            }
            catch (Exception e) {
                MgmtConsole.displayMessage(4, "Error deleting row(s).", e, true);
            }
        }
    }

    class JRemoveButton
    extends JButton {
        public JRemoveButton(BasicResourceAction action) {
            super(action);
        }
    }

    class JEditButton
    extends JButton {
        public JEditButton(BasicResourceAction action) {
            super(action);
        }
    }

    class JAddButton
    extends JButton {
        public JAddButton(BasicResourceAction action) {
            super(action);
        }
    }
}

