/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public final class JTimeField
extends JPanel
implements ActionListener,
FocusListener,
MouseListener {
    JTextField m_hour = new JTextField(new TimeUnitDocument(2), null, 2);
    JLabel m_sep;
    JTextField m_min = new JTextField(new TimeUnitDocument(2), null, 2);

    public JTimeField() {
        this((String)null);
    }

    public JTimeField(String text) {
        super(new GridBagLayout());
        this.m_sep = new JLabel(":");
        this.m_hour.setBorder(null);
        this.m_min.setBorder(null);
        this.m_sep.setOpaque(false);
        this.setProperties(text);
        this.addGridBagConstraints();
    }

    private void addGridBagConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.anchor = 17;
        JPanel pad = new JPanel();
        pad.setOpaque(false);
        this.add((Component)this.m_hour, gbc);
        gbc.gridx = 1;
        this.add((Component)this.m_sep, gbc);
        gbc.gridx = 2;
        this.add((Component)this.m_min, gbc);
        gbc.gridx = 3;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)pad, gbc);
    }

    private final void setProperties(String text) {
        this.setBorder(UIManager.getBorder("TextField.border"));
        this.setBackground(UIManager.getColor("TextField.background"));
        this.setText(text);
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled();
    }

    @Override
    public void setEnabled(boolean b) {
        if (b == this.isEnabled()) {
            return;
        }
        super.setEnabled(b);
        this.m_hour.setEnabled(b);
        this.m_min.setEnabled(b);
    }

    public void setText(String text) {
        int splitPos = text.indexOf(":");
        if (splitPos > 0) {
            this.m_hour.setText(text.substring(0, splitPos).trim());
            this.m_min.setText(text.substring(splitPos + 1).trim());
        }
    }

    public String getText() {
        return this.padString(this.m_hour.getText().trim()) + ":" + this.padString(this.m_min.getText().trim());
    }

    public String getHourText() {
        return this.padString(this.m_hour.getText().trim());
    }

    public String getMinuteText() {
        return this.padString(this.m_min.getText().trim());
    }

    public void addDocumentListener(DocumentListener l) {
        this.m_hour.getDocument().addDocumentListener(l);
        this.m_min.getDocument().addDocumentListener(l);
    }

    public void removeDocumentListener(DocumentListener l) {
        this.m_hour.getDocument().removeDocumentListener(l);
        this.m_min.getDocument().removeDocumentListener(l);
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
    }

    @Override
    public void focusGained(FocusEvent evt) {
    }

    @Override
    public void focusLost(FocusEvent evt) {
    }

    private String padString(String value) {
        if (value.length() == 0) {
            return "00";
        }
        if (value.length() == 1) {
            return "0" + value;
        }
        return value;
    }

    class TimeUnitDocument
    extends PlainDocument {
        private int m_columns;

        public TimeUnitDocument(int columns) {
            this.m_columns = columns;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            str = this.stripNonNumeric(str);
            int newLength = this.getLength() + str.length();
            if (this.getLength() == this.m_columns) {
                Toolkit.getDefaultToolkit().beep();
            }
            if (newLength > this.m_columns) {
                str = str.substring(0, this.m_columns - this.getLength());
            }
            super.insertString(offs, str, a);
        }

        protected String stripNonNumeric(String str) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < str.length(); ++i) {
                if (!Character.isDigit(str.charAt(i))) continue;
                sb.append(str.charAt(i));
            }
            return sb.toString();
        }
    }
}

