/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.Helper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import modelobjects.layout.PartitionLayout;

public class JURIEditor
extends JComponent
implements KeyListener {
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    public static final int ERROR_OPTION = -1;
    private static final int MODE_NOP = 0;
    private static final int MODE_EDIT = 1;
    private static final int MODE_NEW = 2;
    private static int PREF_WIDTH = 500;
    private static int PREF_HEIGHT = 326;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    private static int MIN_WIDTH = 500;
    private static int MIN_HEIGHT = 326;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    JDialog dialog = null;
    JComboBox m_scheme;
    JTextField m_specific;
    JTextField m_fragment;
    JTextField m_authority;
    JTextField m_path;
    JTextField m_query;
    JTextField m_userInfo;
    JTextField m_host;
    JTextField m_port;
    JButton btnOk;
    JButton btnCancel;
    int returnValue;
    int mode = 0;
    URI oldURI;
    boolean formChanged = false;

    public JURIEditor() {
        this.prepareJURIEditor();
    }

    private void prepareJURIEditor() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createURIPanel(), "Center");
        this.add((Component)this.createButtonPanel(), "South");
        this.formUpdate();
    }

    public int showDialog(Component parent) throws HeadlessException {
        this.dialog = this.createDialog(parent);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JURIEditor.this.returnValue = 1;
            }
        });
        this.returnValue = -1;
        this.dialog.show();
        this.dialog.dispose();
        this.dialog = null;
        return this.returnValue;
    }

    protected JDialog createDialog(Component parent) throws HeadlessException {
        Frame frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        JDialog dialog = new JDialog(frame, "URI Editor", true);
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this, "Center");
        this.setPreferredSize(PREF_SIZE);
        this.setMinimumSize(MIN_SIZE);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        return dialog;
    }

    public void setURI(URI uri) {
        this.oldURI = uri;
        String sScheme = uri.getScheme();
        String sPart = uri.getSchemeSpecificPart();
        String sFragment = uri.getFragment();
        this.m_scheme.setSelectedItem(sScheme != null ? sScheme : "");
        this.m_specific.setText(sPart != null ? sPart : "");
        this.m_fragment.setText(sFragment != null ? sFragment : "");
    }

    public URI getURI() {
        try {
            StringBuffer sb = new StringBuffer();
            String sScheme = ((String)this.m_scheme.getSelectedItem()).trim();
            String sPart = this.m_specific.getText().trim();
            String sFragment = this.m_fragment.getText().trim();
            if (sScheme.length() > 0) {
                sb.append(sScheme).append(':');
            }
            sb.append(sPart);
            if (sFragment.length() > 0) {
                sb.append('#').append(sFragment);
            }
            return new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            MgmtConsole.displayMessage(4, "Error while generating URI.", e, true);
            return null;
        }
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new PartitionLayout(false, "r,p,p,r", 5, 2, 2, "JPathChooserButonPanel"));
        this.btnOk = new JButton("OK");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JURIEditor.this.dialog.setVisible(false);
                JURIEditor.this.returnValue = 0;
            }
        });
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JURIEditor.this.dialog.setVisible(false);
                JURIEditor.this.returnValue = 1;
            }
        });
        panel.add(new JPanel());
        panel.add(this.btnOk);
        panel.add(this.btnCancel);
        panel.add(new JPanel());
        return panel;
    }

    private JPanel createURIPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new PartitionLayout(true, "p, p", 5, 2, 2, "JURIEditPanel"));
        panel.add(this.createBasicURIPanel());
        panel.add(this.createHierarchicalURIPanel());
        return panel;
    }

    private JPanel createBasicURIPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new PartitionLayout(false, "p,p,p,r,p,r", 5, 2, 2, "JURIEditBasicPanel"));
        this.m_scheme = new JComboBox();
        this.m_specific = new JTextField();
        this.m_fragment = new JTextField();
        this.m_scheme.setEditable(true);
        this.m_scheme.addItem("file");
        this.m_scheme.addItem("http");
        this.m_scheme.addItem("ftp");
        this.m_scheme.addKeyListener(this);
        this.m_specific.addKeyListener(this);
        this.m_fragment.addKeyListener(this);
        panel.add(new JLabel("URI:"));
        panel.add(this.m_scheme);
        panel.add(new JLabel(":"));
        panel.add(this.m_specific);
        panel.add(new JLabel("#"));
        panel.add(this.m_fragment);
        return panel;
    }

    private JPanel createHierarchicalURIPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new PartitionLayout(false, "p,r", 5, 2, 2, "JURIEditHierarchicalPanel"));
        panel.setBorder(BorderFactory.createTitledBorder("Hierarchical"));
        panel.add(new JLabel("Part:"));
        panel.add(this.createPartPanel());
        panel.add(new JLabel("Authority:"));
        panel.add(this.createAuthorityPanel());
        return panel;
    }

    private JPanel createPartPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new PartitionLayout(false, "p,r,r,p,r", 5, 0, 0, "JURIEditPartPanel"));
        this.m_authority = new JTextField();
        this.m_path = new JTextField();
        this.m_query = new JTextField();
        panel.add(new JPanel());
        panel.add(new JLabel("Authority"));
        panel.add(new JLabel("Path"));
        panel.add(new JPanel());
        panel.add(new JLabel("Query"));
        panel.add(new JLabel("//"));
        panel.add(this.m_authority);
        panel.add(this.m_path);
        panel.add(new JLabel("?"));
        panel.add(this.m_query);
        return panel;
    }

    private JPanel createAuthorityPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new PartitionLayout(false, "r,p,r,p,r", 5, 0, 0, "JURIEditPartPanel"));
        this.m_userInfo = new JTextField();
        this.m_host = new JTextField();
        this.m_port = new JTextField();
        panel.add(new JLabel("User Info"));
        panel.add(new JPanel());
        panel.add(new JLabel("Host"));
        panel.add(new JPanel());
        panel.add(new JLabel("Port"));
        panel.add(this.m_userInfo);
        panel.add(new JLabel("@"));
        panel.add(this.m_host);
        panel.add(new JLabel(":"));
        panel.add(this.m_port);
        return panel;
    }

    protected void formUpdate() {
        this.btnOk.setEnabled(this.formChanged);
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == '\n') {
            return;
        }
        this.formChanged = true;
        Helper.invoke(new Runnable(){

            @Override
            public void run() {
                JURIEditor.this.formUpdate();
            }
        });
    }

    @Override
    public void keyPressed(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }
}

