/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.URLUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.Document;
import modelobjects.layout.PartitionLayout;

public class JURLField
extends JComponent {
    public static final int EDIT_SCHEME = 1;
    public static final int EDIT_HOST = 2;
    public static final int EDIT_PORT = 4;
    protected JTextField m_scheme = new JInnerTextField(5);
    protected JTextField m_host = new JInnerTextField();
    protected JTextField m_port = new JInnerTextField(10);
    protected String m_text = null;
    static int schemeIndex = 0;
    static String[] SCHEME = new String[]{"tcp", "ssl", "http", "https"};

    public JURLField(String text, int editMask) {
        this.prepareJURLField(text, editMask);
    }

    private void prepareJURLField(String text, int editMask) {
        this.setEditMask(editMask);
        this.setLayout(new PartitionLayout(false, "p,p,r,p,p", 5, 0, 0, "JURLField"));
        this.add(this.m_scheme);
        this.add(new JLabel("://"));
        this.add(this.m_host);
        if (editMask > 2) {
            this.add(new JLabel(":"));
        }
        this.add(this.m_port);
        this.setText(text);
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled();
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
    }

    public boolean isEditable() {
        return this.getEditMask() > 0;
    }

    public void setEditable(boolean b) {
        this.setEditMask(0);
    }

    public int getEditMask() {
        int res = 0;
        if (this.m_scheme.isEditable()) {
            ++res;
        }
        if (this.m_host.isEditable()) {
            res += 2;
        }
        if (this.m_port.isEditable()) {
            res += 4;
        }
        return res;
    }

    public void setEditMask(int editMask) {
        this.setFieldEditable(this.m_scheme, (editMask & 1) == 1, 6);
        this.setFieldEditableWithBorder(this.m_host, (editMask & 2) == 2, 16);
        this.setFieldEditable(this.m_port, (editMask & 4) == 4, 10);
    }

    public String getText() {
        StringBuffer sb = new StringBuffer();
        String scheme = this.m_scheme.getText().trim();
        String host = this.m_host.getText().trim();
        String port = this.m_port.getText().trim();
        if (scheme.length() > 0 && host.length() == 0 && port.length() == 0) {
            return "";
        }
        if (scheme.length() > 0) {
            sb.append(scheme).append("://");
        }
        if (host.length() > 0) {
            sb.append(host);
        }
        if (port.length() > 0) {
            sb.append(":").append(port);
        }
        return sb.toString();
    }

    public void setText(String text) {
        block9: {
            this.m_text = text;
            try {
                if (this.m_port.isEditable()) {
                    URLUtility url = new URLUtility(this.m_text, this.m_host.isEditable());
                    this.setSchemeText(url.getBrokerProtocol());
                    this.setHostText(url.getBrokerHostName());
                    int port = url.getBrokerPort();
                    String rawFragment = null;
                    try {
                        URI uri = new URI(this.m_text);
                        rawFragment = uri.getRawFragment();
                    }
                    catch (URISyntaxException e) {
                        MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                    }
                    if (port != -1) {
                        String portNum = Integer.toString(port);
                        if (rawFragment != null) {
                            portNum = portNum + "#" + rawFragment;
                        }
                        this.m_port.setText(portNum);
                    } else if (rawFragment != null) {
                        this.m_port.setText("#" + rawFragment);
                    }
                    break block9;
                }
                int index = this.m_text.indexOf("://");
                String scheme = this.m_text.substring(0, index);
                this.setSchemeText(scheme);
                this.setHostText(this.m_text.substring(index + 3));
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            }
        }
    }

    public void setSchemeText(String text) {
        if (text != null) {
            this.m_scheme.setText(text);
            this.m_scheme.setCaretPosition(0);
            this.revalidate();
        }
    }

    public void setHostText(String text) {
        if (text != null) {
            this.m_host.setText(text);
        }
    }

    @Override
    public void setBackground(Color color) {
        this.m_scheme.setBackground(color);
        this.m_host.setBackground(color);
        this.m_port.setBackground(color);
    }

    @Override
    public Color getBackground() {
        return this.m_scheme.getBackground();
    }

    public Document getSchemeDocument() {
        return this.m_scheme.getDocument();
    }

    public Document getHostDocument() {
        return this.m_host.getDocument();
    }

    public Document getPortDocument() {
        return this.m_port.getDocument();
    }

    private void setFieldEditable(JTextField field, boolean editable, int columns) {
        field.setEditable(editable);
        field.setBorder(editable ? UIManager.getBorder("TextField.border") : null);
        field.setColumns(editable ? columns : 0);
        field.setFocusable(editable);
    }

    private void setFieldEditableWithBorder(JTextField field, boolean editable, int columns) {
        field.setEditable(editable);
        field.setColumns(editable ? columns : 0);
        field.setFocusable(editable);
    }

    public static void main(String[] arg) {
        final JFrame frame = new JFrame("JURLField Text");
        final JURLField field = new JURLField("http://localhost", 4);
        JPartitionPanel panel = new JPartitionPanel(true, "p,r", null);
        JButton scheme = new JButton("Scheme Toggle");
        JButton get = new JButton("getText");
        panel.add(field);
        scheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ++schemeIndex;
                field.setSchemeText(SCHEME[schemeIndex %= SCHEME.length]);
            }
        });
        get.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JOptionPane.showMessageDialog(frame, field.getText());
            }
        });
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)panel, "Center");
        frame.getContentPane().add((Component)scheme, "North");
        frame.getContentPane().add((Component)get, "South");
        frame.setVisible(true);
    }

    class JInnerTextField
    extends JTextField {
        public JInnerTextField() {
            this(0);
        }

        public JInnerTextField(int columns) {
            super(columns);
        }

        @Override
        public void setText(String text) {
            super.setText(text);
            this.setMinimumSize(this.getPreferredSize());
        }
    }
}

