/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.util.URLUtility;
import java.net.MalformedURLException;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.ViewValueConverter;

public class JURLFieldConverter
implements ViewValueConverter {
    private boolean m_needHost;
    private boolean m_needPort;
    private boolean m_isLDAP;

    public JURLFieldConverter(boolean needHost, boolean needPort) {
        this.m_needHost = needHost;
        this.m_needPort = needPort;
    }

    public JURLFieldConverter(boolean needHost, boolean needPort, boolean isLDAP) {
        this(needHost, needPort);
        this.m_isLDAP = isLDAP;
    }

    @Override
    public Object viewValueToModel(Object viewValue) throws ViewValueConversionException {
        if (viewValue == null) {
            throw new ViewValueConversionException("URL is not defined");
        }
        if (!(viewValue instanceof String)) {
            throw new ViewValueConversionException("expected a string");
        }
        String value = ((String)viewValue).trim();
        if (value.length() == 0) {
            if (this.m_isLDAP) {
                return value;
            }
            if (!this.m_needHost && !this.m_needPort) {
                return value;
            }
            throw new ViewValueConversionException("URL is empty");
        }
        try {
            URLUtility url = new URLUtility(value, this.m_needHost);
            if (this.m_needHost && (url.getBrokerHostName() == null || url.getBrokerHostName().length() == 0)) {
                throw new ViewValueConversionException("URL (" + viewValue + ") is missing host");
            }
            if (this.m_needPort && url.getBrokerPort() == -1) {
                throw new ViewValueConversionException("URL (" + viewValue + ") is missing port");
            }
        }
        catch (NullPointerException e) {
            throw new ViewValueConversionException("URL is not valid", e);
        }
        catch (MalformedURLException e) {
            throw new ViewValueConversionException("URL is not valid", e);
        }
        return viewValue;
    }

    @Override
    public Object modelValueToView(Object modelValue) throws ViewValueConversionException {
        return modelValue;
    }

    @Override
    public String[] getViewStringValues() {
        return null;
    }

    @Override
    public boolean isViewValueToModelSupported() {
        return true;
    }

    @Override
    public Class getModelClass() {
        return String.class;
    }

    @Override
    public Class getViewClass() {
        return String.class;
    }
}

