/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.table.IContentPane;
import com.sonicsw.ma.gui.table.ITableContentPane;
import com.sonicsw.ma.gui.util.CommonPopupMenuShower;
import com.sonicsw.ma.plugin.IPlugin;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class PluginMenuShower
extends CommonPopupMenuShower {
    private static final int[] MENU_TYPE = new int[]{1, 2, 3, 4, 5, 7, 6};
    private IContentPane m_contentPane;

    public PluginMenuShower(JTree tree) {
        super(tree, new JPopupMenu());
    }

    public PluginMenuShower(ITableContentPane contentPane) {
        super(contentPane.getTable(), new JPopupMenu());
        this.m_contentPane = contentPane;
    }

    @Override
    protected List getMenuItems() {
        DefaultMutableTreeNode node;
        List list = null;
        if (this.m_contentPane != null) {
            list = new ArrayList();
            for (int i = 0; i < MENU_TYPE.length; ++i) {
                JComponent[] items = null;
                items = this.m_contentPane.getMenuItems(MENU_TYPE[i]);
                this.addToList(list, items);
            }
        } else if (this.getTree() != null && (node = (DefaultMutableTreeNode)this.getTree().getSelectionPath().getLastPathComponent()) instanceof IPlugin) {
            list = this.getMenuItems((IPlugin)((Object)node));
        }
        return list;
    }

    @Override
    protected List getParentMenuItems() {
        return this.getMenuItems(this.m_contentPane.getPlugin());
    }

    private List getMenuItems(IPlugin plugin) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < MENU_TYPE.length; ++i) {
            JComponent[] items = plugin.getMenuItems(MENU_TYPE[i]);
            this.addToList(list, items);
        }
        return list;
    }

    private void addToList(List list, JComponent[] subList) {
        if (subList != null && subList.length > 0) {
            if (!list.isEmpty()) {
                list.add(new JSeparator());
            }
            for (int i = 0; i < subList.length; ++i) {
                list.add(subList[i]);
            }
        }
    }
}

