/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class PopupMenuShower
extends MouseAdapter
implements ActionListener {
    private JTree m_tree;
    private JTable m_table;
    private JPopupMenu m_popup;

    public PopupMenuShower(JPopupMenu popup) {
        this((JTable)null, popup);
    }

    public PopupMenuShower(JTable table, JPopupMenu popup) {
        this.m_table = table;
        this.m_popup = popup;
        JViewport vp = (JViewport)table.getParent();
        if (vp != null) {
            vp.addMouseListener(this);
        }
    }

    public PopupMenuShower(JTree tree, JPopupMenu popup) {
        this.m_tree = tree;
        this.m_popup = popup;
    }

    protected void showMenuIfPopupTrigger(MouseEvent evt) {
        if (this.m_popup != null && this.m_popup.isPopupTrigger(evt)) {
            int row;
            if (this.m_table != null && this.m_table.getSelectedRowCount() < 2) {
                row = this.m_table.rowAtPoint(new Point(evt.getX(), evt.getY()));
                if (row >= 0) {
                    this.m_table.setRowSelectionInterval(row, row);
                }
            } else if (this.m_tree != null && this.m_tree.getSelectionCount() < 2 && (row = this.m_tree.getRowForLocation(evt.getX(), evt.getY())) >= 0) {
                this.m_tree.setSelectionRow(row);
            }
            if (this.m_popup.getComponentCount() > 0) {
                Point loc = this.ensurePopupFullyOnScreen(evt);
                this.m_popup.show(evt.getComponent(), loc.x, loc.y);
            }
        }
    }

    protected Point ensurePopupFullyOnScreen(MouseEvent evt) {
        Component comp = evt.getComponent();
        Dimension ssz = comp.getToolkit().getScreenSize();
        Dimension psz = this.m_popup.getSize();
        Point loc = new Point(evt.getX(), evt.getY());
        SwingUtilities.convertPointToScreen(loc, comp);
        if (loc.y + psz.height > ssz.height) {
            loc.y -= psz.height;
        }
        if (loc.x + psz.width > ssz.width) {
            loc.x -= psz.width;
        }
        SwingUtilities.convertPointFromScreen(loc, comp);
        return loc;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.showMenuIfPopupTrigger(evt);
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.showMenuIfPopupTrigger(evt);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Component comp = (Component)evt.getSource();
        MouseEvent mouseEvent = new MouseEvent(comp, 0, 0L, 0, 0, comp.getHeight() - 1, 0, true);
        if (this.m_popup.getComponentCount() > 0) {
            Point loc = this.ensurePopupFullyOnScreen(mouseEvent);
            this.m_popup.show(comp, loc.x, loc.y);
        }
    }

    public void setPopupMenu(JPopupMenu menu) {
        this.m_popup = menu;
    }

    public JPopupMenu getPopupMenu() {
        return this.m_popup;
    }

    public JTree getTree() {
        return this.m_tree;
    }

    public JTable getTable() {
        return this.m_table;
    }
}

