/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.PreferenceManager;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.JButtonPanel;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.mx.config.ConfigFactory;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigPath;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PricipalChooserDialog
extends JMADialog
implements ListSelectionListener {
    public static final IConfigPath USER_NAME = ConfigFactory.createConfigPath((String)"USER_NAME");
    public static final IConfigPath GROUP_NAME = ConfigFactory.createConfigPath((String)"GROUP_NAME");
    private JList m_aclList;
    private JCheckBox m_showUsers;
    private JCheckBox m_showSystem;
    private Object[] m_userNames;
    private Object[] m_groupNames;
    private Object m_selectedItem;
    private Action m_okAction;
    private boolean m_routingPrincipals = false;
    public static final String GROUP_PREFIX = "#^_";
    public static final String USER_PREFIX = "^@_";

    public PricipalChooserDialog(JMAFrame parent, Object[] users, Object[] groups, boolean routingPrincipals) {
        super(parent, "policy-acl-list");
        this.m_groupNames = this.getUserGroupNames(groups, false);
        this.m_userNames = this.getUserGroupNames(users, true);
        this.m_routingPrincipals = routingPrincipals;
        this.myInit();
        this.setModalProperty();
    }

    private void setModalProperty() {
        this.setModal(true);
    }

    private Object[] getUserGroupNames(Object[] objects, boolean bForUser) {
        Vector<String> vUserName = new Vector<String>();
        try {
            String pefix = bForUser ? USER_PREFIX : GROUP_PREFIX;
            IConfigPath attributeName = bForUser ? USER_NAME : GROUP_NAME;
            for (int i = 0; i < objects.length; ++i) {
                IConfigBean bean = (IConfigBean)objects[i];
                String name = (String)bean.getAttribute(attributeName);
                vUserName.addElement(pefix + name);
            }
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        return vUserName.toArray();
    }

    private static String getRidPrefix(String name) {
        return name.substring(GROUP_PREFIX.length());
    }

    private static String getRidPrefix(Object obj) {
        if (obj == null) {
            return "";
        }
        return PricipalChooserDialog.getRidPrefix(obj.toString());
    }

    @Override
    protected void maInitialize() {
    }

    @Override
    protected void maCleanup() {
        PreferenceManager pm = PreferenceManager.getInstance();
        pm.setBoolean("view", "userPrincipals", this.m_showUsers.isSelected(), false);
        pm.setBoolean("view", "systemPrincipals", this.m_showSystem.isSelected(), false);
    }

    private void myInit() {
        this.m_showUsers = new JCheckBox("Include Users", PreferenceManager.getInstance().getBoolean("view", "userPrincipals", false));
        this.m_showSystem = new JCheckBox("Show System Principals", PreferenceManager.getInstance().getBoolean("view", "systemPrincipals", false));
        this.m_aclList = new JList();
        this.m_aclList.setSelectionMode(0);
        this.updateList();
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(""));
        ExtendedJScrollPane scroll = new ExtendedJScrollPane(this.m_aclList);
        panel.add((Component)scroll, "Center");
        JPartitionPanel checkBoxPanel = new JPartitionPanel(true, "p,p", null);
        checkBoxPanel.add(this.m_showUsers);
        checkBoxPanel.add(this.m_showSystem);
        panel.add((Component)checkBoxPanel, "South");
        this.getContentPane().add("Center", panel);
        this.m_aclList.setCellRenderer(new ACLCellRenderer());
        this.m_aclList.addListSelectionListener(this);
        FilterActionListener fal = new FilterActionListener();
        this.m_showUsers.addActionListener(fal);
        this.m_showSystem.addActionListener(fal);
        this.m_aclList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    ((JButtonPanel)PricipalChooserDialog.this.getButtonPanel()).getButton((String)PricipalChooserDialog.this.m_okAction.getValue("ActionCommandKey")).doClick();
                }
            }
        });
    }

    public String getSelectedItem() {
        return PricipalChooserDialog.getRidPrefix((String)this.m_selectedItem);
    }

    public String getSelectedItemWithPrefix() {
        return (String)this.m_selectedItem;
    }

    private void updateList() {
        String name;
        int i;
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        if (!this.m_routingPrincipals) {
            for (i = 0; i < this.m_groupNames.length; ++i) {
                if (this.m_showSystem.isSelected()) {
                    model.addElement(this.m_groupNames[i]);
                    continue;
                }
                name = PricipalChooserDialog.getRidPrefix((String)this.m_groupNames[i]);
                if (name.startsWith("$")) continue;
                model.addElement(this.m_groupNames[i]);
            }
        }
        if (this.m_showUsers.isSelected()) {
            for (i = 0; i < this.m_userNames.length; ++i) {
                if (this.m_showSystem.isSelected()) {
                    model.addElement(this.m_userNames[i]);
                    continue;
                }
                name = PricipalChooserDialog.getRidPrefix((String)this.m_userNames[i]);
                if (name.startsWith("$")) continue;
                model.addElement(this.m_userNames[i]);
            }
        }
        this.m_aclList.setModel(this.sort(model));
    }

    private DefaultListModel sort(DefaultListModel model) {
        int x;
        Vector list = new Vector();
        for (x = 0; x < model.getSize(); ++x) {
            list.addElement(model.get(x));
        }
        Collections.sort(list, new PrincipalComparator());
        for (x = 0; x < model.getSize(); ++x) {
            if (model.getElementAt(x) == list.elementAt(x)) continue;
            model.set(x, list.elementAt(x));
        }
        return model;
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (evt.getSource() == this.m_aclList) {
            this.m_okAction.setEnabled(true);
        }
    }

    @Override
    public Action[] getButtonActions() {
        this.m_okAction = new OKAction((Action)this.getDefaultOKAction());
        this.m_okAction.setEnabled(false);
        return new Action[]{this.m_okAction, this.getDefaultCancelAction()};
    }

    class OKAction
    extends BasicGuiAction {
        Action m_target;

        public OKAction(Action target) {
            super("AuthorizationPolicyACLListDialog.ok");
            this.m_target = target;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int sel = PricipalChooserDialog.this.m_aclList.getSelectedIndex();
            if (sel >= 0) {
                PricipalChooserDialog.this.m_selectedItem = PricipalChooserDialog.this.m_aclList.getSelectedValue();
                this.m_target.actionPerformed(evt);
            }
        }
    }

    class FilterActionListener
    implements ActionListener {
        FilterActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            PricipalChooserDialog.this.updateList();
            PricipalChooserDialog.this.m_okAction.setEnabled(false);
        }
    }

    class ACLCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public ACLCellRenderer() {
            this.setOpaqueProperty();
        }

        private void setOpaqueProperty() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = value.toString();
            String iconName = text.startsWith(PricipalChooserDialog.GROUP_PREFIX) ? "MF_AUTHENTICATION_GROUP" : "MF_AUTHENTICATION_USER";
            Icon icon = ResourceManager.getTypeIcon(this.getClass(), iconName);
            this.setIcon(icon);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            text = PricipalChooserDialog.getRidPrefix(text);
            this.setText(text);
            return this;
        }
    }

    class PrincipalComparator
    implements Comparator {
        PrincipalComparator() {
        }

        public int compare(Object o1, Object o2) {
            return Collator.getInstance().compare(PricipalChooserDialog.getRidPrefix(o1), PricipalChooserDialog.getRidPrefix(o2));
        }

        @Override
        public boolean equals(Object obj) {
            return Collator.getInstance().equals(obj);
        }

        public int hashCode() {
            return Collator.getInstance().hashCode();
        }
    }
}

