/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.ReferenceToStringConverter;
import com.sonicsw.mf.common.config.query.From;
import com.sonicsw.mf.common.config.query.FromElementType;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigPrototype;
import com.sonicsw.mx.config.IConfigServer;
import java.util.ArrayList;
import java.util.Set;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.ViewValueConverter;

public class QueryConverter
implements ViewValueConverter {
    private IConfigServer m_server;
    private String m_suffix = null;
    private String m_type = null;
    protected static String NONE = "<None>";

    public QueryConverter(IConfigServer server, String type) {
        this.m_server = server;
        this.m_type = type;
    }

    public QueryConverter(IConfigServer server, String type, String suffix) {
        this(server, type);
        this.m_suffix = suffix;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object viewValueToModel(Object viewValue) throws ViewValueConversionException {
        IConfigElement res = null;
        String DSname = null;
        if (!(viewValue instanceof String)) throw new ViewValueConversionException("Expected a string");
        try {
            String value = (String)viewValue;
            if (value.equals(NONE)) {
                return null;
            }
            if (value.length() <= 0) return res;
            DSname = this.m_suffix == null ? ReferenceToStringConverter.convertFromView(value) : ReferenceToStringConverter.convertFromView(value, this.m_suffix);
            return this.m_server.loadConfigElement(DSname);
        }
        catch (ConfigServiceException e) {
            throw new ViewValueConversionException("Could not load " + DSname + " (" + e.getMessage() + ")", e);
        }
        catch (NumberFormatException e) {
            throw new ViewValueConversionException("Not a com.sonicsw.mx.config.impl.Reference string", e);
        }
    }

    @Override
    public Object modelValueToView(Object modelValue) throws ViewValueConversionException {
        if (modelValue == null) {
            return NONE;
        }
        if (modelValue instanceof IConfigBean) {
            String name = ((IConfigBean)modelValue).getName();
            name = this.stripDefaulSuffix(name);
            return ReferenceToStringConverter.convertToView(name);
        }
        throw new ViewValueConversionException("Value not a com.sonicsw.mx.config.IConfigBean");
    }

    @Override
    public String[] getViewStringValues() {
        String[] names = null;
        try {
            Query query = new Query().setFrom((From)new FromElementType(this.m_type));
            Set elements = this.m_server.loadConfigElements(query);
            ArrayList<String> list = new ArrayList<String>(elements.size() + 1);
            list.add(NONE);
            for (IConfigBean bean : elements) {
                String path = bean.getName();
                String name = null;
                if (path.endsWith("_Default") || path.endsWith("_MFDomainDescriptor") || path.endsWith("_MQPolicyDescriptor")) {
                    int lastIndex = path.lastIndexOf(47);
                    path = path.substring(0, lastIndex);
                    name = ReferenceToStringConverter.convertToView(path);
                } else {
                    name = ReferenceToStringConverter.convertToView(path);
                }
                if (bean instanceof IConfigPrototype) continue;
                list.add(name);
            }
            names = list.toArray(new String[list.size()]);
        }
        catch (Exception e) {
            names = new String[]{NONE};
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        return names;
    }

    @Override
    public boolean isViewValueToModelSupported() {
        return true;
    }

    @Override
    public Class getModelClass() {
        return IConfigBean.class;
    }

    @Override
    public Class getViewClass() {
        return String.class;
    }

    protected String stripDefaulSuffix(String name) {
        if (name.endsWith("_Default") || name.endsWith("_MFDomainDescriptor") || name.endsWith("_MQPolicyDescriptor")) {
            int lastIndex = name.lastIndexOf(47);
            name = name.substring(0, lastIndex);
        }
        return name;
    }
}

