/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.IdentityOnlyConfigBean;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.ViewValueConverter;

public class ReferenceToStringConverter
implements ViewValueConverter {
    private IConfigServer m_server;
    private String m_suffix = null;

    public ReferenceToStringConverter(IConfigServer server) {
        this.m_server = server;
    }

    public ReferenceToStringConverter(IConfigServer server, String suffix) {
        this(server);
        this.m_suffix = suffix;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object viewValueToModel(Object viewValue) throws ViewValueConversionException {
        IConfigElement res = null;
        String DSname = null;
        if (IdentityOnlyConfigBean.getUnIndentifiable() != null && viewValue == IdentityOnlyConfigBean.getUnIndentifiable().toString()) {
            return IdentityOnlyConfigBean.getUnIndentifiable();
        }
        if (!(viewValue instanceof String)) throw new ViewValueConversionException("Expected a string");
        try {
            String value = (String)viewValue;
            if (value.length() <= 0) return res;
            DSname = this.m_suffix == null ? ReferenceToStringConverter.convertFromView(value) : ReferenceToStringConverter.convertFromView(value, this.m_suffix);
            return this.m_server.loadConfigElement(DSname);
        }
        catch (ConfigServiceException e) {
            throw new ViewValueConversionException("Could not load " + DSname + " (" + e.getMessage() + ")", e);
        }
        catch (NumberFormatException e) {
            throw new ViewValueConversionException("Not a com.sonicsw.mx.config.impl.Reference string");
        }
    }

    @Override
    public Object modelValueToView(Object modelValue) throws ViewValueConversionException {
        if (modelValue == IdentityOnlyConfigBean.getUnIndentifiable()) {
            return modelValue.toString();
        }
        if (modelValue instanceof IConfigBean) {
            String name = ((IConfigBean)modelValue).getName();
            if (name.endsWith("_Default") || name.endsWith("_MFDomainDescriptor") || name.endsWith("_MQPolicyDescriptor")) {
                int lastIndex = name.lastIndexOf(47);
                name = name.substring(0, lastIndex);
            }
            return ReferenceToStringConverter.convertToView(name);
        }
        throw new ViewValueConversionException("Value not a com.sonicsw.mx.config.IConfigBean");
    }

    public void setSuffix(String suffix) {
        this.m_suffix = suffix;
    }

    public static String convertToView(String value) {
        int pathIndex = value.lastIndexOf(47);
        String path = value.substring(0, pathIndex + 1);
        if (path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return value.substring(pathIndex + 1) + " ( " + path + " )";
    }

    public static String convertFromView(String value) {
        int pathIndex = value.lastIndexOf(40);
        String path = value.substring(pathIndex + 1, value.length() - 1).trim();
        StringBuffer sb = new StringBuffer(path);
        if (path.length() > 1) {
            sb.append('/');
        }
        sb.append(value.substring(0, pathIndex).trim());
        return sb.toString();
    }

    public static String convertFromView(String value, String suffix) {
        int pathIndex = value.lastIndexOf(40);
        String path = value.substring(pathIndex + 1, value.length() - 1).trim();
        String name = value.substring(0, pathIndex).trim();
        StringBuffer sb = new StringBuffer(path);
        if (path.length() > 1) {
            sb.append('/');
        }
        sb.append(name).append('/').append(suffix);
        return sb.toString();
    }

    @Override
    public String[] getViewStringValues() {
        return null;
    }

    @Override
    public boolean isViewValueToModelSupported() {
        return true;
    }

    @Override
    public Class getModelClass() {
        return IConfigBean.class;
    }

    @Override
    public Class getViewClass() {
        return String.class;
    }
}

