/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.Helper;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import progress.message.zclient.Version;

public class ResourceManager {
    private static final String APPLICATION_LOGO = "application.logo";
    private static final String APPLICATION_ICON_36 = "application36.icon";
    private static final String APPLICATION_ICON_18 = "application18.icon";
    private static final String BRANDING_PROPERTIES = "branding.properties";
    public static final String SONICSW_HOME_PROPERTY = "sonicsw.home";
    private static final String RES_BASE = "com.sonicsw.";
    private static final String RES_NAME = ".resrc";
    public static final char SEPARATOR = '/';
    public static final String KEY_CONFIG = "config";
    public static final String KEY_RUNTIME = "runtime";
    public static final String KEY_LABEL = "label";
    public static final String KEY_UNIT = "unit";
    public static final String KEY_LIST = "list";
    private static Class m_classThis = ResourceManager.class;
    private static volatile Properties applicationProperties;
    private static Map<String, Icon> APPLICATION_LOGOS_MAP;
    private static Object LOCK_OBJ;

    public static Object getObject(Class resClass, Object[] key) {
        return ResourceManager.getObject(resClass, ResourceManager.buildKey(key));
    }

    public static Object getObject(Class resClass, Object key) {
        Object res = null;
        String[] baseName = ResourceManager.getBaseNames(resClass);
        Throwable exception = null;
        for (int i = 0; res == null && i < baseName.length; ++i) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(baseName[i] + RES_NAME, Locale.getDefault(), resClass.getClassLoader());
                res = bundle.getObject(key != null ? key.toString() : null);
                continue;
            }
            catch (MissingResourceException e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        if (res == null && exception != null) {
            ResourceManager.debugErrorOutput(exception.getMessage());
        }
        return res;
    }

    public static String getString(Class resClass, Object[] key) {
        return ResourceManager.getString(resClass, ResourceManager.buildKey(key));
    }

    public static String getString(Class resClass, Object key) {
        String res = null;
        String[] baseName = ResourceManager.getBaseNames(resClass);
        Throwable exception = null;
        for (int i = 0; res == null && i < baseName.length; ++i) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(baseName[i] + RES_NAME, Locale.getDefault(), resClass.getClassLoader());
                res = bundle.getString(key != null ? key.toString() : null);
                continue;
            }
            catch (MissingResourceException e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        if (res == null && exception != null) {
            ResourceManager.debugErrorOutput(exception.getMessage());
        }
        return res;
    }

    public static String[] getStringArray(Class resClass, Object[] key) {
        return ResourceManager.getStringArray(resClass, ResourceManager.buildKey(key));
    }

    public static String[] getStringArray(Class resClass, String key) {
        String[] res = new String[]{};
        String[] baseName = ResourceManager.getBaseNames(resClass);
        Throwable exception = null;
        for (int i = 0; res == null && i < baseName.length; ++i) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(baseName[i] + RES_NAME, Locale.getDefault(), resClass.getClassLoader());
                res = bundle.getStringArray(key);
                continue;
            }
            catch (MissingResourceException e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        if (res == null && exception != null) {
            ResourceManager.debugErrorOutput(exception.getMessage());
        }
        return res;
    }

    public static Object getMessage(Class resClass, Object[] key, Object[] args) {
        return ResourceManager.getMessage(resClass, ResourceManager.buildKey(key), args);
    }

    public static String getMessage(Class resClass, Object key, Object[] args) {
        String res = (String)ResourceManager.getObject(resClass, key);
        return res != null ? new MessageFormat(res).format(args) : null;
    }

    public static Object getIcon(Class resClass, Object[] key) {
        return ResourceManager.getIcon(resClass, ResourceManager.buildKey(key));
    }

    public static Icon getIcon(Class resClass, Object key) {
        return ResourceManager.getIcon(resClass, key, ResourceManager.getBaseNames(resClass), "image");
    }

    public static Icon getTypeIcon(Object key) {
        return ResourceManager.getTypeIcon(m_classThis, key);
    }

    public static Icon getTypeIcon(Class resClass, Object key) {
        Icon icon = ResourceManager.getIcon(resClass, key, new String[]{"com.sonicsw.ma.gui"}, "image/type");
        if (icon == null) {
            icon = ResourceManager.getIcon(resClass, null, new String[]{"com.sonicsw.ma.gui"}, "image/type");
        }
        return icon;
    }

    protected static Icon getIcon(Object key, String[] pathBase, String pathPart) {
        return ResourceManager.getIcon(m_classThis, key, pathBase, pathPart);
    }

    protected static Icon getIcon(Class resClass, Object key, String[] pathBase, String pathPart) {
        ImageIcon res = null;
        for (int i = 0; res == null && i < pathBase.length; ++i) {
            String keyValue = key != null ? key.toString() : "Unknown";
            StringBuffer sbImage = new StringBuffer();
            sbImage.append(pathBase[i].replace('.', '/'));
            sbImage.append('/');
            sbImage.append(pathPart);
            sbImage.append('/');
            sbImage.append(keyValue);
            sbImage.append(".gif");
            URL imgUrl = resClass.getClassLoader().getResource(sbImage.toString());
            if (imgUrl == null) continue;
            res = new ImageIcon(imgUrl);
            break;
        }
        if (res == null) {
            String message = "Resource " + key + ".gif could not be found in " + Arrays.toString(pathBase);
            Helper.logDebugMessage(message);
        }
        return res;
    }

    public static Object[] prefixArray(Object[] list, Object item) {
        Object[] newList = new Object[list.length + 1];
        newList[0] = item;
        for (int i = 0; i < list.length; ++i) {
            newList[i + 1] = list[i];
        }
        return newList;
    }

    private static void debugErrorOutput(String value) {
        if (MgmtConsole.DEVELOPER_MODE) {
            Helper.logDebugMessage(value);
        }
    }

    protected static String buildKey(Object[] key) {
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < key.length; ++i) {
            String keyValue;
            if (key[i] == null || (keyValue = key[i].toString().trim()) == null || keyValue.length() <= 0) continue;
            if (res.length() > 0 && res.charAt(res.length() - 1) != '.') {
                res.append('.');
            }
            res.append(keyValue);
        }
        return res.toString();
    }

    protected static String getBaseName(Class resClass) {
        String name;
        String base = name = resClass.getPackage().getName();
        if (name.startsWith(RES_BASE)) {
            base = name.substring(0, name.indexOf(46, RES_BASE.length() + 1));
        }
        return base + ".gui";
    }

    protected static String[] getBaseNames(Class resClass) {
        ArrayList<String> name = new ArrayList<String>();
        Class aClass = resClass;
        Class lastClass = null;
        while (aClass != null) {
            String aName = ResourceManager.getBaseName(aClass);
            if (!name.contains(aName)) {
                name.add(aName);
            }
            lastClass = aClass;
            aClass = aClass.getSuperclass();
            if (!lastClass.getName().startsWith(RES_BASE) || aClass == null || aClass.getName().startsWith(RES_BASE)) continue;
            aClass = null;
        }
        return name.toArray(new String[name.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getApplicationProperties() {
        if (applicationProperties != null) {
            return applicationProperties;
        }
        Object object = LOCK_OBJ;
        synchronized (object) {
            if (applicationProperties == null) {
                applicationProperties = new Properties();
                try {
                    String propsPath = ResourceManager.getMQBinFolderPath() + BRANDING_PROPERTIES;
                    File file = new File(propsPath);
                    if (!file.exists()) {
                        return null;
                    }
                    URL propsURL = file.toURL();
                    applicationProperties.load(propsURL.openStream());
                    return applicationProperties;
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                }
                return null;
            }
            return applicationProperties;
        }
    }

    public static String getApplicationPropertyString(String key) {
        Properties applicationProperties = ResourceManager.getApplicationProperties();
        if (applicationProperties == null) {
            return null;
        }
        return applicationProperties.getProperty(key);
    }

    public static final Icon getApplicationIcon(Class className, String key, int size) {
        if (size == 18) {
            return ResourceManager.getIconOfSize(className, key, APPLICATION_ICON_18);
        }
        if (size == 36) {
            return ResourceManager.getIconOfSize(className, key, APPLICATION_ICON_36);
        }
        return null;
    }

    private static Icon getIconOfSize(Class className, String key, String brandingIconKey) {
        String imgUrl = ResourceManager.getMQBinFolderPath() + ResourceManager.getApplicationPropertyString(brandingIconKey);
        return ResourceManager.getOrCreateIcon(imgUrl, className, key);
    }

    public static Icon getApplicationLogo(Class className, String key) {
        String imgUrl = ResourceManager.getMQBinFolderPath() + ResourceManager.getApplicationPropertyString(APPLICATION_LOGO);
        return ResourceManager.getOrCreateIcon(imgUrl, className, key);
    }

    private static Icon getOrCreateIcon(String imgUrl, Class className, String key) {
        if (APPLICATION_LOGOS_MAP.containsKey(imgUrl)) {
            return APPLICATION_LOGOS_MAP.get(imgUrl);
        }
        if (APPLICATION_LOGOS_MAP.containsKey(className + key)) {
            return APPLICATION_LOGOS_MAP.get(className + key);
        }
        return ResourceManager.createIconImage(imgUrl, className, key);
    }

    private static Icon createIconImage(String imgUrl, Class className, String key) {
        Icon icon;
        if (new File(imgUrl).exists()) {
            icon = new ImageIcon(imgUrl);
            APPLICATION_LOGOS_MAP.put(imgUrl, icon);
        } else {
            icon = ResourceManager.getIcon(className, key);
            APPLICATION_LOGOS_MAP.put(className + key, icon);
        }
        return icon;
    }

    public static final String getMQFolderPath() {
        String SONICSW_HOME = System.getProperty(SONICSW_HOME_PROPERTY);
        return SONICSW_HOME + File.separator + "MQ" + ResourceManager.getMajorMinorVersion() + File.separator;
    }

    private static String getMajorMinorVersion() {
        return Version.getMajorVersion() + "." + Version.getMinorVersion();
    }

    public static final String getMQBinFolderPath() {
        return ResourceManager.getMQFolderPath() + "bin" + File.separator;
    }

    static {
        APPLICATION_LOGOS_MAP = new HashMap<String, Icon>();
        LOCK_OBJ = new Object();
    }
}

