/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.PreferenceManager;
import com.sonicsw.ma.gui.util.ISizeHelper;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JMAInternalFrame;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;

public class SizeHelper
implements ISizeHelper {
    private static final String WINDOW_PREF = "window";
    private static final String WINDOW_WIDTH = "width";
    private static final String WINDOW_HEIGHT = "height";
    private static final String WINDOW_MAX = "max";
    private static final String WINDOW_X = "x";
    private static final String WINDOW_Y = "y";

    public static boolean restoreWindowSize(Container container) {
        PreferenceManager prefMgr;
        boolean restored = false;
        if (SizeHelper.isResizable(container) && (prefMgr = PreferenceManager.getInstance()).getBoolean("preferences.general", "saveWindowSizes", true)) {
            String prefPath = "window." + SizeHelper.getName(container);
            int width = prefMgr.getInt(prefPath, WINDOW_WIDTH, -1);
            int height = prefMgr.getInt(prefPath, WINDOW_HEIGHT, -1);
            if (width != -1 && height != -1) {
                restored = true;
                container.setSize(width, height);
            }
        }
        return restored;
    }

    public static boolean restoreWindowPosition(Container container) {
        boolean restored = false;
        PreferenceManager prefMgr = PreferenceManager.getInstance();
        if (prefMgr.getBoolean("preferences.general", "saveWindowPositions", true)) {
            String prefPath = "window." + SizeHelper.getName(container);
            int x = prefMgr.getInt(prefPath, WINDOW_X, -1);
            int y = prefMgr.getInt(prefPath, WINDOW_Y, -1);
            if (x != -1 && y != -1) {
                restored = true;
                container.setLocation(x, y);
                if (container instanceof JInternalFrame && prefMgr.getBoolean(prefPath, WINDOW_MAX, false)) {
                    try {
                        ((JInternalFrame)container).setMaximum(true);
                    }
                    catch (Exception e) {
                        MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                    }
                }
            }
        }
        return restored;
    }

    public static void saveWindowSize(Container container) {
        PreferenceManager prefMgr = PreferenceManager.getInstance();
        if (SizeHelper.isResizable(container) && prefMgr.getBoolean("preferences.general", "saveWindowSizes", true)) {
            boolean max;
            String prefPath = "window." + SizeHelper.getName(container);
            int width = container.getWidth();
            int height = container.getHeight();
            if (container instanceof JMAInternalFrame && (max = ((JInternalFrame)container).isMaximum())) {
                Rectangle rect = ((JMAInternalFrame)container).getRestoreBounds();
                width = rect.width;
                height = rect.height;
            }
            prefMgr.setInt(prefPath, WINDOW_WIDTH, width, false);
            prefMgr.setInt(prefPath, WINDOW_HEIGHT, height, false);
        }
    }

    public static void saveWindowPosition(Container container) {
        PreferenceManager prefMgr = PreferenceManager.getInstance();
        if (prefMgr.getBoolean("preferences.general", "saveWindowPositions", true)) {
            String prefPath = "window." + SizeHelper.getName(container);
            Point pt = container.getLocation();
            if (container instanceof JMAInternalFrame) {
                boolean max = ((JInternalFrame)container).isMaximum();
                prefMgr.setBoolean(prefPath, WINDOW_MAX, max, false);
                if (max) {
                    Rectangle rect = ((JMAInternalFrame)container).getRestoreBounds();
                    pt.x = rect.x;
                    pt.y = rect.y;
                }
            }
            prefMgr.setInt(prefPath, WINDOW_X, pt.x, false);
            prefMgr.setInt(prefPath, WINDOW_Y, pt.y, true);
        }
    }

    private static String getName(Container container) {
        String name = null;
        String title = null;
        if (container instanceof JMADialog) {
            name = ((JMADialog)container).getTitleKey();
            title = ((JMADialog)container).getTitle();
        } else if (container instanceof JMAInternalFrame) {
            name = ((JMAInternalFrame)container).getTitleKey();
            title = ((JMAInternalFrame)container).getTitle();
        } else if (container instanceof JMAFrame) {
            name = ((JMAFrame)container).getTitleKey();
            title = ((JMAFrame)container).getTitle();
        }
        if (name == null) {
            name = container.getClass().getName();
        }
        if (title != null && title.length() > 0) {
            return name + "." + title.replace('/', '#');
        }
        return name;
    }

    private static boolean isResizable(Container container) {
        if (container instanceof JDialog) {
            return ((JDialog)container).isResizable();
        }
        return true;
    }
}

