/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class SmallBevelBorder
extends AbstractBorder {
    public static final int RAISED = 0;
    public static final int LOWERED = 1;
    protected int bevelType;
    protected Color highlight;
    protected Color shadow;

    public SmallBevelBorder(int bevelType) {
        this.bevelType = bevelType;
    }

    public SmallBevelBorder(int bevelType, Color highlight, Color shadow) {
        this(bevelType);
        this.highlight = highlight;
        this.shadow = shadow;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        int h = height;
        int w = width;
        g.translate(x, y);
        g.setColor(this.bevelType == 0 ? this.getHighlightColor(c) : this.getShadowColor(c));
        g.drawLine(0, 0, 0, h - 1);
        g.drawLine(1, 0, w - 1, 0);
        g.setColor(this.bevelType == 0 ? this.getShadowColor(c) : this.getHighlightColor(c));
        g.drawLine(1, h - 1, w - 1, h - 1);
        g.drawLine(w - 1, 1, w - 1, h - 1);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(1, 2, 1, 2);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.right = 2;
        insets.left = 2;
        insets.bottom = 1;
        insets.top = 1;
        return insets;
    }

    public Color getHighlightColor() {
        return this.highlight;
    }

    public Color getShadowColor() {
        return this.shadow;
    }

    public Color getHighlightColor(Component c) {
        Color highlight = this.getHighlightColor();
        return highlight != null ? highlight : c.getBackground().brighter().brighter();
    }

    public Color getShadowColor(Component c) {
        Color shadow = this.getShadowColor();
        return shadow != null ? shadow : c.getBackground().darker();
    }

    public int getBevelType() {
        return this.bevelType;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

