/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.MgmtConsole;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class URLUtility {
    public static final String TCP = "tcp";
    public static final String HTTP = "http";
    private static final String HTTPS = "https";
    public static final String SSL = "ssl";
    private static final String SSL_IAIK = "ssl.iaik";
    private String m_brokerURL;
    private String m_brokerHostName = "";
    private String m_brokerProtocol = "tcp";
    private int m_brokerPort = -1;
    private static final int PORT = 2506;

    public URLUtility(String brokerURL) throws MalformedURLException {
        this.parseURL(brokerURL, true);
    }

    public URLUtility(String brokerURL, boolean needHost) throws MalformedURLException {
        this.parseURL(brokerURL, needHost);
    }

    public String getBrokerURL() {
        return this.m_brokerURL;
    }

    public String getBrokerHostName() {
        return this.m_brokerHostName;
    }

    public String getBrokerProtocol() {
        return this.m_brokerProtocol;
    }

    public int getBrokerPort() {
        return this.m_brokerPort;
    }

    private void parseURL(String brokerURL, boolean needHost) throws MalformedURLException {
        String host;
        if (brokerURL == null || brokerURL.equals("")) {
            return;
        }
        this.m_brokerURL = brokerURL = brokerURL.trim();
        if (brokerURL.length() >= 6 && brokerURL.substring(0, 6).equalsIgnoreCase("tcp://")) {
            this.m_brokerProtocol = TCP;
            host = brokerURL.substring(6);
        } else if (brokerURL.length() >= 7 && brokerURL.substring(0, 7).equalsIgnoreCase("http://")) {
            this.m_brokerProtocol = HTTP;
            host = brokerURL.substring(7);
        } else if (brokerURL.length() >= 8 && brokerURL.substring(0, 8).equalsIgnoreCase("https://")) {
            this.m_brokerProtocol = HTTPS;
            host = brokerURL.substring(8);
        } else if (brokerURL.length() >= 6 && brokerURL.substring(0, 6).equalsIgnoreCase("ssl://")) {
            this.m_brokerProtocol = SSL;
            host = brokerURL.substring(6);
        } else if (brokerURL.length() >= 11 && brokerURL.substring(0, 11).equalsIgnoreCase("ssl.iaik://")) {
            this.m_brokerProtocol = SSL;
            host = brokerURL.substring(11);
        } else {
            host = brokerURL;
        }
        try {
            if (needHost) {
                this.validateHostname(host);
            }
            URL url = new URL("http://" + host);
            this.m_brokerHostName = url.getHost();
            this.m_brokerPort = url.getPort();
            if (needHost && (this.m_brokerHostName == null || this.m_brokerHostName.length() == 0)) {
                throw new MalformedURLException("Missing hostname");
            }
            if (this.m_brokerPort == -1) {
                this.m_brokerPort = 2506;
            }
        }
        catch (MalformedURLException e) {
            MalformedURLException ex = new MalformedURLException("Invalid host name syntax: " + host + " (broker url: " + brokerURL + ")");
            ex.initCause(e);
            throw ex;
        }
        catch (URISyntaxException e) {
            MalformedURLException ex = new MalformedURLException("Invalid host name syntax: " + host + " (broker url: " + brokerURL + ")");
            ex.initCause(e);
            throw ex;
        }
    }

    private void validateHostname(String host) throws URISyntaxException, MalformedURLException {
        URI uri = new URI("http://" + host.replace('_', 'Z'));
        String hostname = uri.getHost();
        if (hostname == null || hostname.length() == 0) {
            throw new MalformedURLException("Missing hostname");
        }
        hostname = "";
        if (host.indexOf(":") > 0) {
            try {
                hostname = host.substring(0, host.indexOf(":"));
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            }
            if (hostname != null && hostname.indexOf("#") > 0) {
                throw new MalformedURLException("Invalid hostname");
            }
        }
    }
}

