/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.config.DSFileChooser;
import com.sonicsw.ma.gui.config.FileElementFilter;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.IPluginFilter;
import com.sonicsw.mf.common.config.query.From;
import com.sonicsw.mf.common.config.query.FromElementType;
import com.sonicsw.mf.common.config.query.FromFolder;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigPrototype;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.IdentityOnlyConfigBean;
import java.awt.Window;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public class Utils {
    public static final String USER_LOCATION_SUFFIX = "/_MFUsers/";
    public static final String EXTERNAL_USER_LOCATION_SUFFIX = "/external/_MFUsers/";
    public static final String GROUP_LOCATION_SUFFIX = "/_MFGroups/";
    public static final String EXTERNAL_GROUP_LOCATION_SUFFIX = "/external/_MFGroups/";

    public static String chooseFile(Window parentDialog, IPlugin plugin, String[] filters) {
        FileElementFilter filter = new FileElementFilter();
        filter.setSelectedFilter(filters[0]);
        IPluginContext pluginContext = plugin.getPluginContext();
        IConfigServer server = pluginContext.getConnectionInfo().getConfigServer();
        DSFileChooser dialog = null;
        if (parentDialog instanceof JPropSheetDialog) {
            dialog = new DSFileChooser((JPropSheetDialog)parentDialog, "file.choose", pluginContext, server, (IPluginFilter)filter, filters, false);
        } else if (parentDialog instanceof JMAFrame) {
            dialog = new DSFileChooser((JMAFrame)parentDialog, "file.choose", pluginContext, server, (IPluginFilter)filter, filters, false);
        }
        try {
            if (dialog != null) {
                HashMap selList;
                dialog.editInstance(plugin, new HashMap(), false);
                dialog.setVisible(true);
                if (dialog.getCloseCommand() == 0 && (selList = (HashMap)dialog.getModel()) != null && !selList.isEmpty()) {
                    return "sonicfs://" + selList.keySet().iterator().next();
                }
            } else {
                MgmtConsole.displayMessage(4, "Unable to create dialog.", true);
            }
        }
        catch (Exception e1) {
            MgmtConsole.displayMessage(4, "Failed to choose file.", e1, true);
        }
        return null;
    }

    public static Set getDomainUsers(String domain, IConfigServer server) {
        return Utils.getDomainUsers(domain, server, false);
    }

    public static Set getDomainUsers(String domain, IConfigServer server, boolean includeExternal) {
        try {
            if (domain == null) {
                return Collections.EMPTY_SET;
            }
            String usersDir = domain + USER_LOCATION_SUFFIX;
            FromFolder fromUsersDir = new FromFolder(usersDir);
            Query getUsersQuery = new Query();
            getUsersQuery.setFrom((From)fromUsersDir);
            Set internalUsers = server.loadConfigElements(getUsersQuery);
            if (!includeExternal) {
                return internalUsers;
            }
            String externalUsersDir = domain + EXTERNAL_USER_LOCATION_SUFFIX;
            try {
                fromUsersDir = new FromFolder(externalUsersDir);
                getUsersQuery.setFrom((From)fromUsersDir);
                Set externalUsers = server.loadConfigElements(getUsersQuery);
                internalUsers.addAll(externalUsers);
            }
            catch (Exception e1) {
                MgmtConsole.getMgmtConsole().notifyMessage(64, e1.getMessage(), e1, false);
            }
            return internalUsers;
        }
        catch (Exception e1) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Could not get a principal list", e1, true);
            return Collections.EMPTY_SET;
        }
    }

    public static Set getDomainGroups(String domain, IConfigServer server) {
        return Utils.getDomainGroups(domain, server, false);
    }

    public static Set getDomainGroups(String domain, IConfigServer server, boolean includeExternal) {
        try {
            if (domain == null) {
                return Collections.EMPTY_SET;
            }
            String groupsDir = domain + GROUP_LOCATION_SUFFIX;
            FromFolder fromGroupsDir = new FromFolder(groupsDir);
            Query getGroupsQuery = new Query();
            getGroupsQuery.setFrom((From)fromGroupsDir);
            Set internalGroups = server.loadConfigElements(getGroupsQuery);
            if (!includeExternal) {
                return internalGroups;
            }
            fromGroupsDir = new FromFolder(domain + EXTERNAL_GROUP_LOCATION_SUFFIX);
            getGroupsQuery.setFrom((From)fromGroupsDir);
            try {
                Set externalGroups = server.loadConfigElements(getGroupsQuery);
                internalGroups.addAll(externalGroups);
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            }
            return internalGroups;
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Could not get a principal list", e, true);
            return Collections.EMPTY_SET;
        }
    }

    public static String getDefaultAuthenticationDomainDir(IConfigServer server) {
        try {
            Query query = new Query().setFrom((From)new FromElementType("MF_AUTHENTICATION_DOMAIN"));
            Set elements = server.loadConfigElements(query);
            for (IConfigBean bean : elements) {
                String path = bean.getName();
                if (path.endsWith("_Default") || path.endsWith("_MFDomainDescriptor") || path.endsWith("_MQPolicyDescriptor")) {
                    int lastIndex = path.lastIndexOf(47);
                    path = path.substring(0, lastIndex);
                }
                if (bean instanceof IConfigPrototype) continue;
                return path;
            }
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        return null;
    }

    public static String getConfigBeanIdentifierName(IConfigBean iConfigBean) {
        String ret = iConfigBean.toString();
        if (!IdentityOnlyConfigBean.isUnidentifiable((IConfigBean)iConfigBean)) {
            ret = iConfigBean.getName();
        }
        if (ret != null && ret.endsWith("_Default")) {
            int index = ret.lastIndexOf(47);
            ret = ret.substring(0, index);
        }
        return ret;
    }
}

