/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.plugin;

import com.sonicsw.ma.gui.config.propsheets.JConfigDialog;
import com.sonicsw.ma.plugin.IContainerExtensionFactory;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigPrototype;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.util.ConfigHelper;

public abstract class AbstractExtensionFactory
implements IContainerExtensionFactory {
    @Override
    public abstract String getId();

    @Override
    public String getDescription() {
        return this.getId();
    }

    @Override
    public abstract String getConfigType();

    @Override
    public abstract String getConfigVersion();

    public abstract String getProductVersion();

    @Override
    public abstract JConfigDialog getPropertySheet(JConfigDialog var1, IPluginContext var2) throws Exception;

    @Override
    public boolean isComponentDependent(String type, String productVersion, String configVersion) {
        return false;
    }

    protected String getPath(IConfigBean containerBean) {
        return "/System/Container Extensions/" + containerBean.getName().substring(containerBean.getName().lastIndexOf("/") + 1);
    }

    @Override
    public void modelCreated(IConfigBean createdBean) throws ConfigServiceException {
    }

    @Override
    public void modelCopied(IConfigBean copiedBean) throws ConfigServiceException {
    }

    @Override
    public IConfigBean createModel(IConfigBean containerBean) throws ConfigServiceException {
        IConfigServer server = containerBean.getConfigServer();
        String fPath = this.getPath(containerBean);
        String path = fPath + "/" + this.getId();
        containerBean.getConfigServer().createFolder(fPath, null, true);
        System.out.println("creating extension model " + this.getConfigType() + ", v" + this.getConfigVersion() + " in '" + path + "'");
        boolean isTemplate = containerBean instanceof IConfigPrototype;
        IConfigBean bean = ConfigHelper.createBean((IConfigServer)server, (String)path, (String)this.getConfigType(), (String)this.getConfigVersion(), (String)this.getProductVersion(), (boolean)isTemplate);
        this.modelCreated(bean);
        return bean;
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.getId() + ", " + this.getDescription() + ", " + this.getConfigType() + ", " + this.getConfigVersion() + "]";
    }
}

