/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.plugin;

import com.sonicsw.ma.gui.JWorkspacePanel;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.perms.ManagementSecurityUtils;
import com.sonicsw.ma.gui.table.IContentPane;
import com.sonicsw.ma.gui.table.MessageContentPane;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.FilterTreeNode;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginChangeListener;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.IPluginFilter;
import com.sonicsw.ma.plugin.PluginAttributes;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mx.config.IConfigServer;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractGUIPlugin
extends FilterTreeNode
implements IPlugin {
    protected IContentPane m_pluginContentPane = null;
    private PluginAttributes m_attributes;
    private IPluginContext m_context;
    private IPluginFilter m_filter;
    private String m_name;
    private boolean m_sorted = true;
    private String m_dummyParentPath;
    private ManagementSecurityUtils.Readability readability;

    public AbstractGUIPlugin(IPluginContext context, String name) {
        this.m_context = context;
        this.m_name = name;
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
        super.setParent(newParent);
        if (this.getAttributes().isChildBearing() && this.getChildCount() == 0) {
            this.add(new DefaultMutableTreeNode(Boolean.TRUE));
        }
    }

    public final void setSorted(boolean sorted) {
        this.m_sorted = sorted;
    }

    protected int insert(IPlugin childPlugin) {
        int returnIndex = 0;
        this.insertChild(childPlugin);
        returnIndex = -1;
        if (childPlugin instanceof FilterTreeNode && ((FilterTreeNode)((Object)childPlugin)).canDisplay()) {
            returnIndex = this.getVisibleChildIndex((TreeNode)((Object)childPlugin));
        }
        return returnIndex;
    }

    protected void insertChild(final IPlugin childPlugin) {
        if (this.m_sorted) {
            final int nIndex = this.getInsertIndex(childPlugin.getPluginName());
            Helper.invoke(new Runnable(){

                @Override
                public void run() {
                    AbstractGUIPlugin.this.insert((MutableTreeNode)((Object)childPlugin), nIndex);
                }
            }, true);
        } else {
            Helper.invoke(new Runnable(){

                @Override
                public void run() {
                    AbstractGUIPlugin.this.add((MutableTreeNode)((Object)childPlugin));
                }
            }, true);
        }
        if (childPlugin instanceof AbstractGUIPlugin) {
            Helper.invoke(new Runnable(){

                @Override
                public void run() {
                    ((AbstractGUIPlugin)childPlugin).postInsert();
                }
            });
        }
    }

    protected void postInsert() {
        boolean isChildBearing;
        PluginAttributes attributes = this.getAttributes();
        boolean bl = isChildBearing = attributes != null && attributes.isChildBearing();
        if (!isChildBearing || !this.canDisplay()) {
            return;
        }
        if (!this.getReadability().readable) {
            this.removeAllChildren();
            if (attributes != null) {
                attributes.set("CHILD_BEARING", Boolean.FALSE);
            }
        }
    }

    public Map getMetaAttributes() {
        Map mapAttributes = null;
        try {
            IConfigServer server = this.getPluginContext().getConfigContext().getConfigServer();
            mapAttributes = server.getMetaAttributes(this.getPluginPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapAttributes;
    }

    public TreeNode findChildNode(String strName) {
        TreeNode nodeResult = null;
        this.getPluginContext().getWorkspace().getSelectedWorkspacePanel().doExpansion(this, false, false, false);
        for (int i = 0; i < this.getChildCount(); ++i) {
            TreeNode node = this.getChildAt(i);
            if (!((DefaultMutableTreeNode)node).toString().equals(strName)) continue;
            nodeResult = node;
            break;
        }
        return nodeResult;
    }

    protected int addChildPlugin(IPlugin childPlugin, Map metaAttributes) {
        if (!this.isExpanded()) {
            return -1;
        }
        IPluginFilter filter = this.getFilter();
        if (filter != null && !filter.isPluginVisible(JTree.class, childPlugin)) {
            return -1;
        }
        return this.insert(childPlugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setChildPlugins(List<IPlugin> childPlugins) {
        if (!this.isExpanded()) {
            return;
        }
        IPluginFilter filter = this.getFilter();
        Iterator<IPlugin> iterator = childPlugins.iterator();
        while (iterator.hasNext()) {
            IPlugin childPlugin = iterator.next();
            if (filter == null || filter.isPluginVisible(JTree.class, childPlugin)) continue;
            iterator.remove();
        }
        if (this.m_sorted) {
            Collections.sort(childPlugins, new Comparator<IPlugin>(){

                @Override
                public int compare(IPlugin o1, IPlugin o2) {
                    return Collator.getInstance().compare(o1.getPluginName(), o2.getPluginName());
                }
            });
        }
        boolean sorted = this.m_sorted;
        this.m_sorted = false;
        try {
            Iterator<IPlugin> iterator2 = childPlugins.iterator();
            while (iterator2.hasNext()) {
                this.insertChild(iterator2.next());
            }
        }
        finally {
            this.m_sorted = sorted;
        }
    }

    protected IPlugin createChildPlugin(String strName, Map metaAttributes) {
        return null;
    }

    @Override
    public String getPluginName() {
        return this.m_name;
    }

    @Override
    public void setPluginName(String name) {
        this.m_name = name;
    }

    public void setDummyParentPath(String dummyParentPath) {
        this.m_dummyParentPath = dummyParentPath;
    }

    @Override
    public String getPluginPath() {
        StringBuffer sb = new StringBuffer();
        if (this.m_dummyParentPath != null) {
            sb.append(this.m_dummyParentPath);
            if (!this.m_dummyParentPath.endsWith("/")) {
                sb.append("/");
            }
            sb.append(this.getPluginName());
        } else {
            AbstractGUIPlugin pluginParent = (AbstractGUIPlugin)this.getParent();
            if (pluginParent != null) {
                String path = pluginParent.getPluginPath();
                sb.append(path);
            }
            if (!sb.toString().endsWith("/")) {
                sb.append("/");
            }
            if (!this.isRoot()) {
                sb.append(this.getPluginName());
            }
        }
        return sb.toString();
    }

    public String _getPluginName() {
        return this.getPluginName();
    }

    public String _getPluginPath() {
        return this.getPluginPath();
    }

    @Override
    public final PluginAttributes getAttributes() {
        return this.m_attributes;
    }

    @Override
    public void dispose() {
        this.m_context = null;
        this.m_attributes = null;
        this.m_pluginContentPane = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IPlugin)) {
            return false;
        }
        IPlugin plugin = (IPlugin)object;
        if (plugin instanceof FilterTreeNode && ((FilterTreeNode)((Object)plugin)).canDisplay() != this.canDisplay()) {
            return false;
        }
        if (!plugin.getPluginPath().equals(this.getPluginPath())) {
            return false;
        }
        return plugin.getPluginContext().getConnectionInfo().equals(this.getPluginContext().getConnectionInfo());
    }

    public int hashCode() {
        return Objects.hash(this.canDisplay(), this.getPluginPath(), this.getPluginContext().getConnectionInfo());
    }

    @Override
    public IPluginFilter getFilter() {
        if (this.m_filter != null) {
            return this.m_filter;
        }
        TreeNode parent = this.getParent();
        if (parent != null && parent instanceof AbstractGUIPlugin) {
            return ((AbstractGUIPlugin)parent).getFilter();
        }
        return null;
    }

    @Override
    public void setFilter(IPluginFilter filter) {
        this.m_filter = filter;
    }

    @Override
    public boolean isFilterLocal() {
        return this.m_filter != null;
    }

    @Override
    public String toString() {
        return this.getPluginName();
    }

    public abstract boolean expand();

    public String getToolTipText() {
        List list = this.getToolTipList();
        if (list == null || list.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<HTML><BODY><TABLE CELLPADDING=1>");
        for (int i = 0; i < list.size(); ++i) {
            sb.append(list.get(i).toString());
        }
        if (MgmtConsole.DEVELOPER_MODE) {
            for (PluginAttributes attributes = this.m_attributes; attributes != null; attributes = attributes.getParent()) {
                sb.append("<tr></tr>");
                for (String key : attributes.keySet(false)) {
                    sb.append(this.formatToolTipText(key, attributes.toString(attributes.get(key))));
                }
            }
        }
        sb.append("</TABLE></BODY></HTML>");
        return sb.toString();
    }

    protected String formatToolTipText(String key, String value) {
        return "<tr><td><b>" + key + ":" + "</b></td><td>" + value + "</td></tr>";
    }

    @Override
    public List getToolTipList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.formatToolTipText("Name", this.getPluginName()));
        list.add(this.formatToolTipText("Type", this.getAttributes().getDisplayType()));
        String cVersion = this.getAttributes().getConfigVersion();
        String pVersion = this.getAttributes().getProductVersion();
        if (pVersion != null) {
            list.add(this.formatToolTipText("Product Version", pVersion));
        }
        if (cVersion != null) {
            list.add(this.formatToolTipText("Config Version", cVersion));
        }
        return list;
    }

    public final void setAttributes(PluginAttributes attributes) {
        this.m_attributes = attributes;
    }

    @Override
    public AbstractButton[] getToolbarItems() {
        return new AbstractButton[0];
    }

    @Override
    public IPluginContext getPluginContext() {
        return this.m_context;
    }

    @Override
    public IContentPane getPluginContentPane() {
        if (this.m_pluginContentPane == null) {
            try {
                this.m_pluginContentPane = this.createPluginContentPane();
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, "Unable to create content pane.", e, true);
            }
        }
        return this.m_pluginContentPane;
    }

    public boolean isExpanded() {
        DefaultMutableTreeNode flag;
        DefaultMutableTreeNode defaultMutableTreeNode = flag = this.getChildCount() > 0 ? (DefaultMutableTreeNode)this.getFirstChild() : null;
        return flag == null || !(flag.getUserObject() instanceof Boolean);
    }

    @Override
    public void refresh() {
        if (this.isExpanded()) {
            JWorkspacePanel workspace = this.getWorkspacePanel();
            workspace.doCollapse(this);
            workspace.doExpansion(this, true, false, false);
        } else {
            this.getTreeModel().nodeChanged(this);
        }
        this.getWorkspacePanel().refreshContentPaneIfShown(this);
    }

    public boolean pathExists(String strPath) {
        return this.getPluginContext().getConfigContext().getConfigServer().pathExists(strPath);
    }

    @Override
    public void onAdded(String name, Map attributes) {
        try {
            IPlugin child = this.createChildPlugin(null, attributes);
            int nIndex = this.addChildPlugin(child, attributes);
            if (child != null) {
                IContentPane cp;
                if (nIndex != -1) {
                    this.getTreeModel().nodesWereInserted(this, new int[]{nIndex});
                }
                if ((cp = this.getContentPaneIfShown(this)) != null) {
                    if (cp instanceof IPluginChangeListener) {
                        ((IPluginChangeListener)((Object)cp)).onAdded(child);
                    } else {
                        cp.refresh();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onDeleted(IPlugin child) {
        try {
            boolean bDisplayedNode;
            AbstractGUIPlugin aChild = (AbstractGUIPlugin)child;
            IContentPane cp = this.getContentPaneIfShown(this);
            if (cp != null) {
                if (cp instanceof IPluginChangeListener) {
                    ((IPluginChangeListener)((Object)cp)).onDeleted(child);
                } else {
                    cp.refresh();
                }
            }
            boolean selected = this.getTree().isPathSelected(new TreePath(aChild.getPath()));
            int index = this.getIndex(aChild);
            boolean bl = bDisplayedNode = !(aChild instanceof FilterTreeNode) || aChild instanceof FilterTreeNode && aChild.canDisplay();
            if (bDisplayedNode) {
                index = this.getVisibleChildIndex(aChild);
            }
            this.remove(aChild);
            if (index != -1 && bDisplayedNode) {
                this.getTreeModel().nodesWereRemoved(this, new int[]{index}, new Object[]{child});
                if (selected) {
                    DefaultMutableTreeNode newNode = this;
                    if (index > 0) {
                        newNode = (DefaultMutableTreeNode)this.getChildAt(index - 1);
                    }
                    this.getTree().setSelectionPath(new TreePath(newNode.getPath()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onUpdated() {
        try {
            this.getTreeModel().nodeChanged(this);
            IContentPane cp = this.getContentPaneIfShown(this);
            if (cp != null) {
                if (cp instanceof IPluginChangeListener) {
                    ((IPluginChangeListener)((Object)cp)).onUpdated(this);
                } else {
                    cp.refresh();
                }
            } else {
                AbstractGUIPlugin parent = (AbstractGUIPlugin)this.getParent();
                if (parent != null && (cp = this.getContentPaneIfShown(parent)) != null) {
                    if (cp instanceof IPluginChangeListener) {
                        ((IPluginChangeListener)((Object)cp)).onUpdated(this);
                    } else {
                        cp.refresh();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onRenamed(String newPath) {
        String oldPath = this.getPluginPath();
        String oldBase = oldPath.substring(0, oldPath.lastIndexOf(47));
        String newBase = newPath.substring(0, newPath.lastIndexOf(47));
        AbstractGUIPlugin parent = (AbstractGUIPlugin)this.getParent();
        String newName = newPath.substring(newPath.lastIndexOf(47) + 1);
        if (oldBase.equals(newBase)) {
            IContentPane cp;
            this.setPluginName(newName);
            this.getTreeModel().nodeChanged(this);
            if (parent != null && (cp = this.getContentPaneIfShown(parent)) != null) {
                if (cp instanceof IPluginChangeListener) {
                    ((IPluginChangeListener)((Object)cp)).onRenamed(this);
                } else {
                    cp.refresh();
                }
            }
        } else {
            AbstractGUIPlugin newParent = (AbstractGUIPlugin)((AbstractGUIPlugin)this.getRoot()).goToPlugin(newBase);
            if (newParent != null) {
                IContentPane cp;
                int newIndex = newParent.getInsertIndex(newName);
                this.getTreeModel().removeNodeFromParent(this);
                this.setPluginName(newName);
                this.getTreeModel().insertNodeInto(this, newParent, newIndex);
                if (newParent != null && (cp = this.getContentPaneIfShown(newParent)) != null) {
                    if (cp instanceof IPluginChangeListener) {
                        ((IPluginChangeListener)((Object)cp)).onRenamed(this);
                    } else {
                        cp.refresh();
                    }
                }
            }
        }
    }

    public IPlugin goToPlugin(String path) {
        IPlugin node = this;
        StringTokenizer tokens = new StringTokenizer(path, "/");
        while (tokens.hasMoreTokens() && (node = (IPlugin)((Object)node.findChildNode(tokens.nextToken()))) != null) {
        }
        if (node != null) {
            TreePath pathToNode = new TreePath(((DefaultMutableTreeNode)((Object)node)).getPath());
            this.getTree().expandPath(pathToNode);
            this.getTree().invalidate();
        } else {
            Helper.logErrorMessage("Failed to find configuration node with path '" + path + "'");
        }
        return node;
    }

    @Override
    public BasicAction getDefaultAction() {
        Action action;
        JComponent[] c = this.getPropertiesMenuItems();
        if (c != null && c.length > 0 && c[c.length - 1] instanceof AbstractButton && (action = ((AbstractButton)c[c.length - 1]).getAction()) instanceof BasicAction) {
            return (BasicAction)action;
        }
        return null;
    }

    @Override
    public JComponent[] getMenuItems(int type) {
        JComponent[] ret = null;
        if (type == 2) {
            ret = this.getPluginMenuItems();
        } else if (type == 3) {
            ret = this.getEditMenuItems();
        } else if (type == 5) {
            ret = this.getViewMenuItems();
        } else if (type == 4) {
            ret = this.getSystemMenuItems();
        } else if (type == 6) {
            ret = this.getPropertiesMenuItems();
        } else if (type == 1) {
            ret = this.getNewMenuItems();
        } else if (type == 7) {
            return this.getPermissionsMenuItems();
        }
        return ret;
    }

    protected IContentPane createPluginContentPane() {
        if (!this.getReadability().readable) {
            return new MessageContentPane(this, this.readability.message);
        }
        return this.createReadablePluginContentPane();
    }

    protected IContentPane createReadablePluginContentPane() {
        return null;
    }

    protected ManagementSecurityUtils.Readability getReadability() {
        if (this.readability != null) {
            return this.readability;
        }
        if (this.isReadDeniable()) {
            this.readability = ManagementSecurityUtils.getReadability(this);
            return this.readability;
        }
        this.readability = ManagementSecurityUtils.Readability.READABLE;
        return this.readability;
    }

    protected boolean isReadDeniable() {
        return ManagementSecurityUtils.allowsConfigPerms(this);
    }

    protected JComponent[] getPluginMenuItems() {
        return null;
    }

    protected JComponent[] getNewMenuItems() {
        return null;
    }

    protected JComponent[] getPropertiesMenuItems() {
        return null;
    }

    protected JComponent[] getEditMenuItems() {
        return null;
    }

    protected JComponent[] getSystemMenuItems() {
        return null;
    }

    protected JComponent[] getViewMenuItems() {
        return null;
    }

    protected JComponent[] getPermissionsMenuItems() {
        return ManagementSecurityUtils.getPermissionsMenuItems(this);
    }

    @Override
    public void renamePlugin(IConfigServer configServer, String newPath) throws Exception {
        MgmtConsole.getMgmtConsole().notifyMessage(4, "Rename plugin not yet implemented.", true);
    }

    @Override
    public void deletePlugin(IConfigServer configServer) throws Exception {
        MgmtConsole.getMgmtConsole().notifyMessage(4, "Delete plugin not yet implemented.", true);
    }

    @Override
    public void copyPlugin(IConfigServer server, String path, Object copyData) throws Exception {
        MgmtConsole.getMgmtConsole().notifyMessage(4, "Copy plugin not yet implemented.", true);
    }

    public String getMonitorPath() {
        return this.getPluginPath();
    }

    @Override
    public String[] getAllSupportedMonitors() {
        return new String[0];
    }

    @Override
    public boolean isMonitorSupported(String monitorId) {
        return false;
    }

    @Override
    public Object getMonitorModel(String monitorId) {
        return null;
    }

    protected abstract JWorkspacePanel getWorkspacePanel();

    protected JTree getTree() {
        return this.getWorkspacePanel().getTree();
    }

    protected DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)this.getWorkspacePanel().getTree().getModel();
    }

    protected IContentPane getContentPaneIfShown(IPlugin plugin) {
        return this.getWorkspacePanel().getContentPaneIfShown(plugin);
    }

    protected IElementIdentity createElementIdentity(String path, String type) {
        return new DummyElementIdentity(path, type);
    }

    class DummyElementIdentity
    implements IElementIdentity {
        private String m_name;
        private String m_type;

        public DummyElementIdentity(String name, String type) {
            this.m_name = name;
            this.m_type = type;
        }

        public long getCreationTimestamp() {
            return System.currentTimeMillis();
        }

        public long getVersion() {
            return 0L;
        }

        public String getType() {
            return this.m_type;
        }

        public String getReleaseVersion() {
            return null;
        }

        public boolean equalVersion(IElementIdentity elementID) {
            return false;
        }

        public boolean equalEntity(IElementIdentity elementID) {
            return false;
        }

        public String[] getNameComponents() {
            StringTokenizer st = new StringTokenizer(this.m_name, "/");
            String[] res = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                res[i++] = st.nextToken();
            }
            return res;
        }

        public String getName() {
            return this.m_name;
        }
    }
}

