/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.plugin;

import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.IPluginFactory;
import com.sonicsw.ma.plugin.PluginAttributes;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import java.util.Map;

public abstract class AbstractPluginFactory
implements IPluginFactory {
    private PluginAttributes m_attributes;
    private IPluginFactory[] m_childFactories;

    @Override
    public final PluginAttributes getAttributes() {
        return this.m_attributes;
    }

    public final void setAttributes(PluginAttributes attributes) {
        this.m_attributes = attributes;
    }

    @Override
    public void init(IDirElement element) throws Exception {
    }

    @Override
    public final IPluginFactory[] getChildFactories() {
        if (this.m_childFactories == null) {
            this.m_childFactories = this.createChildFactories();
            if (this.m_childFactories != null) {
                for (int i = 0; i < this.m_childFactories.length; ++i) {
                    this.m_childFactories[i].getAttributes().set("PRODUCT_VERSIONS", this.getAttributes().get("PRODUCT_VERSIONS"));
                }
            }
        }
        return this.m_childFactories;
    }

    protected IPluginFactory[] createChildFactories() {
        return new IPluginFactory[0];
    }

    public IPlugin newInstance(IPluginContext context, String id, Map data) throws Exception {
        return null;
    }

    @Override
    public IPlugin createPlugin(IPluginContext context, String id, String pVersion, Map data) throws Exception {
        String[] versions = this.getAttributes().getProductVersions();
        if (pVersion == null) {
            pVersion = versions[0];
            Helper.logDebugMessage("AbstractPluginFactory::createPlugin() " + this.getClass().getName() + " no version specified for " + id + " - use " + pVersion);
        } else {
            if (versions == null || versions.length == 0) {
                throw new Exception("AbstractPluginFactory::createPlugin(): " + this.getClass().getName() + " - no product versions defined");
            }
            boolean found = false;
            for (int i = 0; i < versions.length; ++i) {
                if (!versions[i].equals(pVersion)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new Exception("AbstractPluginFactory::createPlugin(): " + this.getClass().getName() + " - product version " + pVersion + " not supported");
            }
        }
        IPlugin plugin = this.newInstance(context, id, data);
        if (plugin != null) {
            plugin.getAttributes().set("PRODUCT_VERSION", pVersion);
            plugin.getAttributes().setParent(this.getAttributes());
        }
        return plugin;
    }
}

