/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.plugin;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;

public abstract class AbstractPluginTreeCellRenderer
extends DefaultTreeCellRenderer {
    private int m_gray = 0;
    private Font highlightFont = null;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean isLeaf, int rowNum, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, isLeaf, rowNum, hasFocus);
        this.setGrayIcon(0);
        if (this.highlightFont == null) {
            this.highlightFont = tree.getFont().deriveFont(3);
        }
        if (!tree.isFocusOwner()) {
            this.setBackgroundSelectionColor(UIManager.getColor("ComboBox.disabledBackground"));
            this.setForeground(this.getTextNonSelectionColor());
        } else {
            this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        }
        this.setFont(tree.getFont());
        this.setIcon(UIManager.getIcon(expanded ? "Tree.openIcon" : "Tree.closedIcon"));
        if (value instanceof AbstractGUIPlugin) {
            Object clipboardObject;
            AbstractGUIPlugin node = (AbstractGUIPlugin)value;
            this.updateRenderer(this, node);
            if (MgmtConsole.getMgmtConsole().getClipboardAction() == 0 && (clipboardObject = MgmtConsole.getMgmtConsole().getClipboardObject()) != null && clipboardObject.equals(value)) {
                this.setGrayIcon(40);
            }
        } else {
            this.setIcon(null);
            this.setText("Loading...");
        }
        return this;
    }

    public void highlight(boolean state) {
        if (state) {
            this.setFont(this.highlightFont);
        }
    }

    public void setGrayIcon(int percentage) {
        this.m_gray = percentage;
    }

    @Override
    public Icon getIcon() {
        Icon icon = super.getIcon();
        if (this.m_gray > 0) {
            icon = Helper.createDisabledIcon(icon, this.m_gray);
        }
        return icon;
    }

    public abstract void updateRenderer(JLabel var1, AbstractGUIPlugin var2);
}

