/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.plugin;

import com.sonicsw.ma.gui.IConfigurableTool;
import com.sonicsw.ma.gui.IConfigurableWorkspaceTool;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.domain.DomainConnectionModel;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.ToolInfo;
import java.util.HashMap;
import javax.swing.JInternalFrame;

public class ClasspathToolInfo
extends ToolInfo {
    protected String m_classname;
    protected ClassLoader m_classloader;

    public ClasspathToolInfo(String name, String description, String classname) {
        this(null, name, description, classname, null, false);
    }

    public ClasspathToolInfo(IPluginContext context, String name, String description, String classname, ClassLoader classloader, boolean configure) {
        this.m_classname = classname;
        this.m_classloader = classloader;
        this.commonInit(context, name, description, configure);
    }

    @Override
    public boolean canEnable() {
        boolean res = false;
        try {
            ClassLoader cl = this.m_classloader != null ? this.m_classloader : this.getClass().getClassLoader();
            Class.forName(this.m_classname, false, cl);
            res = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    @Override
    public void execute() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ClassLoader cl = ClasspathToolInfo.this.m_classloader != null ? ClasspathToolInfo.this.m_classloader : this.getClass().getClassLoader();
                    Class<?> cls = Class.forName(ClasspathToolInfo.this.m_classname, false, cl);
                    Class<?> toolCls = Class.forName("com.sonicsw.ma.gui.IConfigurableTool", false, cl);
                    if (toolCls.isAssignableFrom(cls)) {
                        IConfigurableTool obj = (IConfigurableTool)cls.newInstance();
                        JInternalFrame frame = ClasspathToolInfo.this.m_configure && ClasspathToolInfo.this.m_context != null ? obj.create(ClasspathToolInfo.this.buildConfiguration(ClasspathToolInfo.this.m_context.getConnectionInfo())) : obj.create();
                        if (frame.isVisible()) {
                            if (frame.isIcon()) {
                                frame.setIcon(false);
                            }
                            frame.moveToFront();
                        } else {
                            MgmtConsole.getMgmtConsole().showInternalFrame(frame, true);
                        }
                    } else {
                        Object obj = cls.newInstance();
                        if (obj instanceof JInternalFrame) {
                            MgmtConsole.getMgmtConsole().showInternalFrame((JInternalFrame)obj, true);
                        }
                    }
                }
                catch (Exception e) {
                    MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to launch tool " + ClasspathToolInfo.this.m_classname, e, true);
                }
            }
        });
        t.start();
    }

    protected HashMap buildConfiguration(DomainConnectionModel model) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DOMAIN", model.getDomainName());
        map.put("URL", model.getUrl());
        String str = model.getUserName();
        if (str != null && str.length() > 0) {
            map.put("USER", str);
        }
        if ((str = model.getPassword()) != null && str.length() > 0) {
            map.put("PASSWORD", str);
        }
        map.put("TIMEOUT", new Integer(model.getTimeout()));
        map.put("USE_DRA", new Boolean(model.isUseDRA()));
        str = model.getManagementNode();
        if (str != null && str.length() > 0) {
            map.put("MANAGEMENT_NODE", str);
        }
        map.put("LOAD_BALANCING", new Boolean(model.isLoadBalancing()));
        return map;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" [");
        sb.append("classname: ").append(this.m_classname);
        sb.append(" ]");
        return sb.toString();
    }

    public boolean isVisibleInMenu() {
        if (!this.canEnable()) {
            return false;
        }
        try {
            ClassLoader cl = this.m_classloader != null ? this.m_classloader : this.getClass().getClassLoader();
            Class<?> cls = Class.forName(this.m_classname, false, cl);
            if (IConfigurableWorkspaceTool.class.isAssignableFrom(cls)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public Class getRootPluginClass() {
        if (!this.canEnable()) {
            return null;
        }
        try {
            ClassLoader cl = this.m_classloader != null ? this.m_classloader : this.getClass().getClassLoader();
            Class<?> cls = Class.forName(this.m_classname, false, cl);
            if (IConfigurableWorkspaceTool.class.isAssignableFrom(cls)) {
                IConfigurableWorkspaceTool cwTool = (IConfigurableWorkspaceTool)cls.newInstance();
                return cwTool.getConfigRootNodeClass();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

