/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.plugin;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.ToolInfo;
import com.sonicsw.ma.util.FileTracker;
import com.sonicsw.ma.util.FileTrackerHandler;
import java.io.File;
import java.io.IOException;

public class CommandLineToolInfo
extends ToolInfo {
    protected String m_commandLine;
    protected File m_fileArgument;

    public CommandLineToolInfo(String name, String description, String commandLine, File fileArgument) {
        this(null, name, description, commandLine, fileArgument, false);
    }

    public CommandLineToolInfo(IPluginContext context, String name, String description, String commandLine, File fileArgument, boolean configure) {
        this.m_commandLine = commandLine;
        this.m_fileArgument = fileArgument;
        this.commonInit(context, name, description, configure);
    }

    protected CommandLineToolInfo() {
    }

    @Override
    public boolean canEnable() {
        return true;
    }

    @Override
    public void execute() {
        this.execute(null);
    }

    public void execute(final FileTrackerHandler handler) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (CommandLineToolInfo.this.m_fileArgument != null && handler != null) {
                        FileTracker.add(handler);
                    }
                    Process p = Runtime.getRuntime().exec(CommandLineToolInfo.this.createCommand());
                    int exitCode = p.waitFor();
                    if (CommandLineToolInfo.this.m_fileArgument != null && handler != null) {
                        FileTracker.remove(handler);
                    }
                    if (handler != null) {
                        handler.fileFinished(exitCode);
                    }
                }
                catch (Exception e) {
                    MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to launch tool " + CommandLineToolInfo.this.m_commandLine, e, true);
                }
            }
        });
        t.start();
    }

    protected String createCommand() throws IOException {
        StringBuffer sb = new StringBuffer(this.m_commandLine);
        if (this.m_fileArgument != null) {
            if (this.m_fileArgument.exists()) {
                sb.append(" ");
                sb.append(this.m_fileArgument.getAbsolutePath());
            } else {
                throw new IOException("Could not find file [" + this.m_fileArgument.getAbsolutePath() + "]");
            }
        }
        return sb.toString();
    }
}

