/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.plugin;

import com.sonicsw.mx.config.ConfigFactory;
import com.sonicsw.mx.config.IAttributeDescription;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.IConfigPrototype;
import com.sonicsw.mx.config.impl.AttributeMapImpl;

public class ConfigBeanModel {
    public static final IConfigPath NAME = ConfigFactory.createConfigPath((String)"_VIEW_NAME");
    private IAttributeList m_configDataList;
    private IAttributeMap m_configData;
    private IAttributeDescription m_configType;
    private String m_viewName;

    public ConfigBeanModel(IConfigBean configData) {
        this.setConfigBeanModelData(configData);
        String path = configData.getName();
        if (path.endsWith("_MFDomainDescriptor") || path.endsWith("_MQPolicyDescriptor") || path.endsWith("_Default")) {
            path = path.substring(0, path.lastIndexOf(47));
        }
        this.setViewName(path.substring(path.lastIndexOf(47) + 1));
    }

    private void setConfigBeanModelData(IConfigBean configData) {
        this.setData((IAttributeMap)configData);
        this.setType(null);
    }

    public ConfigBeanModel(IConfigBean configData, String viewName) {
        this((IAttributeMap)configData, null, viewName);
    }

    public ConfigBeanModel(IAttributeMap configData, IAttributeDescription configType, String viewName) {
        this.setConfigBeanModelObj(configData, configType);
        this.setViewName(viewName);
    }

    public ConfigBeanModel(IAttributeList configData, IAttributeDescription configType, String viewName) {
        this.setConfigBeanModelObj(configData, configType);
        this.setViewName(viewName);
    }

    private void setConfigBeanModelObj(IAttributeMap configData, IAttributeDescription configType) {
        this.setData(configData);
        this.setType(configType);
    }

    private void setConfigBeanModelObj(IAttributeList configData, IAttributeDescription configType) {
        this.setData(configData);
        this.setType(configType);
    }

    public IAttributeMap getData() {
        return this.m_configData;
    }

    public IAttributeList getDataList() {
        return this.m_configDataList;
    }

    protected void setData(IAttributeMap configData) {
        this.m_configData = configData;
        this.m_configDataList = null;
    }

    protected final void setData(IAttributeList configData) {
        this.m_configData = null;
        this.m_configDataList = configData;
    }

    public String getViewName() {
        return this.m_viewName;
    }

    public final void setViewName(String viewName) {
        this.m_viewName = viewName;
    }

    public String getConfigName() {
        if (this.getData() instanceof IConfigBean) {
            return ((IConfigBean)this.getData()).getName();
        }
        return null;
    }

    public IAttributeDescription getType() {
        IAttributeDescription res = this.m_configType;
        if (this.m_configData instanceof IConfigBean) {
            res = ((IConfigBean)this.m_configData).getConfigType();
        }
        return res;
    }

    public boolean isTemplateInstance() {
        boolean res = false;
        if (this.getData() != null) {
            if (this.getData() instanceof IConfigBean) {
                res = ((IConfigBean)this.getData()).isPrototypeInstance();
            } else if (this.getData() instanceof AttributeMapImpl) {
                IConfigElement owner = ((AttributeMapImpl)this.getData()).getOwner();
                res = owner != null && owner.isPrototypeInstance();
            }
        }
        return res;
    }

    public boolean isTemplate() {
        return this.getData() instanceof IConfigPrototype;
    }

    protected void setType(IAttributeDescription configType) {
        this.m_configType = this.getData() instanceof IConfigBean ? null : configType;
    }
}

