/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.plugin;

import com.sonicsw.ma.plugin.IConfigPluginFactory;
import com.sonicsw.ma.plugin.IPluginFactory;
import com.sonicsw.ma.plugin.PluginAttributes;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import java.util.HashMap;

public class ConfigFactoryInfo {
    private ClassLoader m_classLoader;
    private IConfigPluginFactory m_rootFactory;
    private HashMap m_childFactories = new HashMap();

    public ConfigFactoryInfo(String className, ClassLoader classLoader, IDirElement element) throws Exception {
        this.m_classLoader = classLoader;
        this.m_rootFactory = (IConfigPluginFactory)Class.forName(className, true, this.m_classLoader).newInstance();
        this.m_rootFactory.init(element);
        this.recurseChildren(this.m_rootFactory);
    }

    public IConfigPluginFactory getRootFactory() {
        return this.m_rootFactory;
    }

    public HashMap getChildFactoryMap() {
        return this.m_childFactories;
    }

    public IConfigPluginFactory getChildFactory(String type, String cVersion, String pVersion) {
        if (cVersion == null || cVersion.equals(this.m_rootFactory.getAttributes().getConfigVersion())) {
            IConfigPluginFactory factory = (IConfigPluginFactory)this.m_childFactories.get(type);
            if (pVersion == null) {
                return factory;
            }
            if (factory != null) {
                String[] versions = factory.getAttributes().getProductVersions();
                for (int i = 0; i < versions.length; ++i) {
                    if (!versions[i].equals(pVersion)) continue;
                    return factory;
                }
            }
        }
        return null;
    }

    private void recurseChildren(IConfigPluginFactory factory) {
        IPluginFactory[] children = factory.getChildFactories();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            IConfigPluginFactory child = (IConfigPluginFactory)children[i];
            PluginAttributes attributes = child.getAttributes();
            if (!this.m_childFactories.containsKey(attributes.getType())) {
                this.m_childFactories.put(attributes.getType(), child);
            }
            this.recurseChildren(child);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        IConfigPluginFactory rootFactory = this.getRootFactory();
        PluginAttributes attributes = rootFactory.getAttributes();
        sb.append("ConfigFactoryInfo (");
        sb.append("type=").append(attributes.getType());
        sb.append(", cV=").append(attributes.getConfigVersion());
        sb.append(", pV=").append(attributes.getProductVersion());
        sb.append(", label=").append(attributes.getDisplayType());
        sb.append(", family=").append(attributes.getProductFamilyId());
        sb.append(")");
        return sb.toString();
    }
}

