/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.plugin;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IPlugin;
import javax.swing.JComponent;
import javax.swing.JTextField;
import modelobjects.framework.EditRule;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.swing.JTextFieldAdapter;

public class EditPluginDialog
extends JPropSheetDialog {
    public static final int MODE_CREATE = 0;
    public static final int MODE_EDIT = 1;
    private JTextField m_textName = new JTextField(30);
    private Model m_model;
    private int m_mode = 0;

    public EditPluginDialog(JMAFrame parent) {
        this(parent, 0, null);
    }

    public EditPluginDialog(JMAFrame parent, int mode, IPlugin plugin) {
        super(parent, null, Model.class);
        this.m_mode = mode;
        this.m_model = new Model(plugin);
        this.setProperties();
    }

    private void setProperties() {
        this.setResizable(false);
        this.setTitle();
    }

    @Override
    public void maInitialize() {
        super.maInitialize();
        try {
            super.editInstance(null, this.m_model, false);
            this.m_textName.setSelectionStart(0);
            this.m_textName.setSelectionEnd(this.m_textName.getText().length());
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Unable to initialize dialog.", e, true);
        }
    }

    @Override
    public void initUI() throws Exception {
        JPartitionPanel panel = new JPartitionPanel("");
        panel.addRow("Name", (JComponent)this.m_textName);
        super.getContentPane().add(JPartitionPanel.wrap(panel));
    }

    @Override
    public void initForm() throws Exception {
        new JTextFieldAdapter(ModelAspectId.forName("name"), this.m_textName, EditRule.ALWAYS, null, this.getMediator());
    }

    protected void setTitle() {
        if (this.m_mode == 0) {
            this.setTitle(ResourceManager.getString(this.getClass(), "dialog.create.folder.title"));
        } else if (this.m_model.getPlugin() != null) {
            StringBuffer sbTitle = new StringBuffer(ResourceManager.getString(this.getClass(), "dialog.edit.title"));
            sbTitle.append(" ").append(this.m_model.getPlugin().getAttributes().getDisplayType());
            this.setTitle(sbTitle.toString());
        }
    }

    public class Model {
        private IPlugin m_plugin = null;
        private String m_name = null;

        public Model(IPlugin plugin) {
            this.setPlugin(plugin);
        }

        public String getName() {
            return this.m_name;
        }

        public void setName(String name) {
            this.m_name = name;
        }

        public IPlugin getPlugin() {
            return this.m_plugin;
        }

        public final void setPlugin(IPlugin plugin) {
            this.m_plugin = plugin;
            if (plugin != null) {
                this.m_name = plugin.getPluginName();
            }
        }
    }
}

