/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.plugin;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.plugin.PluginJarFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class JarFileCache {
    private static JarFileCache m_cache = null;
    protected Collection m_colJarFiles = Collections.synchronizedCollection(new ArrayList());
    protected String m_strCachePath = System.getProperty("user.home") + File.separator + ".smc_cache";

    protected JarFileCache() {
    }

    public static synchronized JarFileCache getInstance() {
        if (m_cache == null) {
            m_cache = new JarFileCache();
        }
        return m_cache;
    }

    public static String getCachePath() {
        return JarFileCache.getInstance().m_strCachePath;
    }

    public static void add(PluginJarFile fileJar) {
        JarFileCache.getInstance().m_colJarFiles.add(fileJar);
        try {
            boolean bNeedsUpdating = true;
            if (fileJar.isCached()) {
                bNeedsUpdating = fileJar.needsUpdating();
            }
            if (bNeedsUpdating) {
                fileJar.cacheFile();
            }
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.getMgmtConsole(), 3, "Could not load " + fileJar.getRelativePath() + " from DS.", e, true);
        }
    }

    public static void remove(PluginJarFile fileJar) {
        JarFileCache.getInstance().m_colJarFiles.remove(fileJar);
    }
}

