/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.plugin;

import com.sonicsw.ma.plugin.ClasspathToolInfo;
import com.sonicsw.ma.plugin.ConfigFactoryInfo;
import com.sonicsw.ma.plugin.EditorInfo;
import com.sonicsw.ma.plugin.IAnnotationProvider;
import com.sonicsw.ma.plugin.IConfigPluginFactory;
import com.sonicsw.ma.plugin.IPluginFactory;
import com.sonicsw.ma.plugin.IRuntimePluginFactory;
import com.sonicsw.ma.plugin.PluginAttributes;
import com.sonicsw.ma.plugin.RuntimeFactoryInfo;
import com.sonicsw.ma.plugin.ToolInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

public final class MFLibraryMap {
    private HashMap m_configMap = new HashMap();
    private HashMap m_runtimeMap = new HashMap();
    private HashMap m_toolMap = new HashMap();
    private HashMap m_editorMap = new HashMap();
    private List m_annotationList = null;

    public void addConfigRootFactoryInfo(ConfigFactoryInfo info) {
        PluginAttributes attributes = info.getRootFactory().getAttributes();
        String type = attributes.getType();
        ArrayList<ConfigFactoryInfo> list = (ArrayList<ConfigFactoryInfo>)this.m_configMap.get(type);
        if (list == null) {
            list = new ArrayList<ConfigFactoryInfo>();
            this.m_configMap.put(type, list);
        }
        list.add(info);
    }

    public HashMap getConfigRootFactoryMap() {
        return this.m_configMap;
    }

    public IConfigPluginFactory getChildConfigPluginFactory(String type, String cVersion, String pVersion) {
        IConfigPluginFactory factory = null;
        Iterator iter = this.m_configMap.values().iterator();
        while (iter.hasNext() && factory == null) {
            ArrayList list = (ArrayList)iter.next();
            for (int i = 0; i < list.size() && (factory = ((ConfigFactoryInfo)list.get(i)).getChildFactory(type, cVersion, pVersion)) == null; ++i) {
            }
        }
        return factory;
    }

    public void addRuntimeRootFactoryInfo(RuntimeFactoryInfo info) {
        PluginAttributes attributes = info.getRootFactory().getAttributes();
        String type = attributes.getType();
        ArrayList<RuntimeFactoryInfo> list = (ArrayList<RuntimeFactoryInfo>)this.m_runtimeMap.get(attributes.getType());
        if (list == null) {
            list = new ArrayList<RuntimeFactoryInfo>();
            this.m_runtimeMap.put(type, list);
        }
        list.add(info);
    }

    public HashMap getRuntimeRootFactoryMap() {
        return this.m_runtimeMap;
    }

    public IRuntimePluginFactory getChildRuntimePluginFactory(String type, String cVersion, String pVersion) {
        IRuntimePluginFactory factory = null;
        Iterator iter = this.m_runtimeMap.values().iterator();
        while (iter.hasNext() && factory == null) {
            ArrayList list = (ArrayList)iter.next();
            for (int i = 0; i < list.size() && (factory = ((RuntimeFactoryInfo)list.get(i)).getChildFactory(type, cVersion, pVersion)) == null; ++i) {
            }
        }
        return factory;
    }

    public String[] getRootRuntimePluginTypes() {
        ArrayList<String> res = new ArrayList<String>();
        for (ArrayList list : this.m_runtimeMap.values()) {
            for (int i = 0; i < list.size(); ++i) {
                RuntimeFactoryInfo info = (RuntimeFactoryInfo)list.get(i);
                Iterator iter2 = info.getChildFactoryMap().values().iterator();
                while (iter2.hasNext()) {
                    PluginAttributes attributes = ((IPluginFactory)iter2.next()).getAttributes();
                    if (!attributes.isRuntimeRoot() || res.contains(attributes.getType())) continue;
                    res.add(attributes.getType());
                }
            }
        }
        return res.toArray(new String[res.size()]);
    }

    public HashMap getToolsMap() {
        return this.m_toolMap;
    }

    public void addToolInfo(ToolInfo info) {
        this.m_toolMap.put(info.getKey(), info);
    }

    public JComponent[] getToolsMenuItems() {
        ArrayList<JMenuItem> list = new ArrayList<JMenuItem>();
        Iterator iter = this.m_toolMap.keySet().iterator();
        while (iter.hasNext()) {
            ToolInfo info = (ToolInfo)this.m_toolMap.get(iter.next());
            if (info instanceof ClasspathToolInfo && !((ClasspathToolInfo)info).isVisibleInMenu()) continue;
            list.add(info.getMenuItem());
        }
        return list.toArray(new JComponent[list.size()]);
    }

    public void addAnnotationProvider(IAnnotationProvider provider) {
        if (provider == null) {
            return;
        }
        if (this.m_annotationList == null) {
            this.m_annotationList = new ArrayList();
        }
        this.m_annotationList.add(provider);
    }

    public IAnnotationProvider getAnnotationProvider(String type, String cVersion, String pVersion) {
        if (this.m_annotationList == null) {
            return null;
        }
        for (IAnnotationProvider provider : this.m_annotationList) {
            if (!provider.isAnnotationSupported(type, cVersion, pVersion)) continue;
            return provider;
        }
        return null;
    }

    public HashMap getEditorsMap() {
        return this.m_editorMap;
    }

    public void addEditorInfo(EditorInfo info) {
        this.m_editorMap.put(info.getKey(), info);
    }
}

