/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.plugin;

import com.sonicsw.mf.common.runtime.IState;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PluginAttributes {
    public static final String TYPE = "TYPE";
    public static final String CONFIG_VERSION = "CONFIG_VERSION";
    public static final String PRODUCT_VERSION = "PRODUCT_VERSION";
    public static final String PRODUCT_VERSIONS = "PRODUCT_VERSIONS";
    public static final String DISPLAY_TYPE = "DISPLAY_TYPE";
    public static final String PLUGIN_REVISION = "PLUGIN_REVISION";
    public static final String IS_TEMPLATABLE = "TEMPLATABLE";
    public static final String IS_CREATABLE = "CREATABLE";
    public static final String IS_SYSTEM = "SYSTEM";
    public static final String IS_CHILD_BEARING = "CHILD_BEARING";
    public static final String IS_COMPONENT = "COMPONENT";
    public static final String IS_RELOADABLE = "RELOADABLE";
    public static final String STATE = "STATE";
    public static final String IS_STATEABLE = "STATEABLE";
    public static final String IS_RUNTIME_ROOT = "RUNTIME_ROOT";
    public static final String MBEAN_INFO = "MBEAN_INFO";
    public static final String METRIC_INFO = "METRIC_INFO";
    public static final String IS_DYNAMIC_RUNTIME = "DYNAMIC_RUNTIME";
    public static final String IS_UPGRADEABLE = "UPGRADEABLE";
    public static final String PRODUCT_FAMILY_ID = "PRODUCT_FAMILY_ID";
    public static final String PRIMARY_CONFIGURATION = "PRIMARY_CONFIGURATION";
    private PluginAttributes m_parent;
    private HashMap m_map;

    public PluginAttributes() {
        this(null);
    }

    public PluginAttributes(PluginAttributes parent) {
        this(parent, new HashMap());
    }

    public PluginAttributes(PluginAttributes parent, Object[][] attributes) {
        this(parent);
        this.put(attributes);
    }

    public PluginAttributes(PluginAttributes parent, HashMap attributes) {
        this.m_parent = parent;
        this.m_map = attributes;
    }

    public Object get(String key) {
        Object res;
        Object object = res = this.hasParent() ? this.getParent().get(key) : null;
        if (this.m_map.containsKey(key)) {
            res = this.m_map.get(key);
        }
        return res;
    }

    public void set(String key, Object value) {
        this.m_map.put(key, value);
    }

    public Set keySet() {
        return this.keySet(true);
    }

    public Set keySet(boolean inherit) {
        Set res = null;
        if (inherit && this.hasParent()) {
            res = new HashSet(this.getParent().keySet(inherit));
            res.addAll(this.m_map.keySet());
        } else {
            res = this.m_map.keySet();
        }
        return res;
    }

    public boolean containsKey(String key) {
        return this.keySet().contains(key);
    }

    public int size() {
        return this.keySet().size();
    }

    public boolean isEmpty() {
        return this.keySet().isEmpty();
    }

    public final void put(PluginAttributes attributes) {
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                this.set(key, attributes.get(key));
            }
        }
    }

    public final void put(Map attributes) {
        if (attributes != null) {
            this.m_map.putAll(attributes);
        }
    }

    public final void put(Map attributes, String[] excludeKeys) {
        PluginAttributes.put(this.m_map, attributes, excludeKeys);
    }

    public static Map put(Map dst, Map src, String[] excludeKeys) {
        if (dst != null && src != null) {
            for (String key : src.keySet()) {
                boolean exclude = false;
                if (excludeKeys != null) {
                    for (int j = 0; j < excludeKeys.length; ++j) {
                        if (excludeKeys[j] != key) continue;
                        exclude = true;
                        break;
                    }
                }
                if (exclude) continue;
                dst.put(key, src.get(key));
            }
        }
        return dst;
    }

    public final void put(Object[][] attributes) {
        if (attributes != null) {
            for (int i = 0; i < attributes.length; ++i) {
                Object[] attribute = attributes[i];
                if (attribute == null || attribute.length != 2) continue;
                this.set(attribute[0].toString(), attribute[1]);
            }
        }
    }

    protected boolean hasParent() {
        return this.getParent() != null;
    }

    public PluginAttributes getParent() {
        return this.m_parent;
    }

    protected void setParent(PluginAttributes parent) {
        this.m_parent = parent;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (String key : this.m_map.keySet()) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(key).append('=').append(this.toString(this.m_map.get(key)));
        }
        return buffer.toString();
    }

    private String formatStringArray(String[] val) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < val.length; ++i) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(val[i]);
        }
        return buffer.toString();
    }

    public String toString(Object val) {
        String ret = null;
        ret = val instanceof String[] ? this.formatStringArray((String[])val) : (val instanceof IState ? ((IState)val).getStateString() : (val instanceof String ? (String)val : (val instanceof Boolean ? val.toString() : "?")));
        return ret;
    }

    public boolean getBooleanValue(String key) {
        Boolean val = (Boolean)this.get(key);
        return val != null ? val : false;
    }

    public String getType() {
        return (String)this.get(TYPE);
    }

    public String getDisplayType() {
        return (String)this.get(DISPLAY_TYPE);
    }

    public String getConfigVersion() {
        return (String)this.get(CONFIG_VERSION);
    }

    public String getProductVersion() {
        return (String)this.get(PRODUCT_VERSION);
    }

    public String[] getProductVersions() {
        Object productVersionObject = this.get(PRODUCT_VERSIONS);
        if (productVersionObject instanceof Collection) {
            Collection productVersionCollection = (Collection)productVersionObject;
            return productVersionCollection.toArray(new String[productVersionCollection.size()]);
        }
        return (String[])productVersionObject;
    }

    public String getProductVersionsString() {
        return this.formatStringArray(this.getProductVersions());
    }

    public String getProductFamilyId() {
        return (String)this.get(PRODUCT_FAMILY_ID);
    }

    public String getPluginRevision() {
        return (String)this.get(PLUGIN_REVISION);
    }

    public String getConfigProductVersion() {
        String cVersion = this.getConfigVersion();
        String pVersion = this.getProductVersion();
        if (pVersion == null && cVersion == null) {
            return null;
        }
        if (pVersion == null) {
            pVersion = "Unknown";
        }
        if (cVersion == null) {
            cVersion = "Unknown";
        }
        return pVersion + " (" + cVersion + ")";
    }

    public boolean isTemplatable() {
        return this.getBooleanValue(IS_TEMPLATABLE);
    }

    public boolean isCreatable() {
        return this.getBooleanValue(IS_CREATABLE);
    }

    public boolean isUpgradeable() {
        return this.getBooleanValue(IS_UPGRADEABLE);
    }

    public boolean isSystem() {
        boolean bIsSystem = false;
        String strResult = (String)this.get(IS_SYSTEM);
        if (strResult != null) {
            bIsSystem = strResult.equals("true");
        }
        return bIsSystem;
    }

    public boolean isChildBearing() {
        return this.getBooleanValue(IS_CHILD_BEARING);
    }

    public IState getState() {
        return (IState)this.get(STATE);
    }

    public final void setState(IState state) {
        this.set(STATE, state);
    }

    public boolean isStateable() {
        return this.getBooleanValue(IS_STATEABLE);
    }

    public boolean isRuntimeRoot() {
        return this.getBooleanValue(IS_RUNTIME_ROOT);
    }

    public boolean isReloadable() {
        return this.getBooleanValue(IS_RELOADABLE);
    }

    public boolean isComponent() {
        return this.getBooleanValue(IS_COMPONENT);
    }

    public boolean isDynamicRuntime() {
        return this.getBooleanValue(IS_DYNAMIC_RUNTIME);
    }

    public boolean isPrimaryConfiguration() {
        return this.getBooleanValue(PRIMARY_CONFIGURATION);
    }
}

