/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.plugin;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.domain.DomainConnectionModel;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.plugin.JarFileCache;
import com.sonicsw.ma.plugin.PluginJarFile;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;

public class PluginClassLoader
extends URLClassLoader {
    public PluginClassLoader(String classpath, DomainConnectionModel connectionInfo) throws Exception {
        super(new URL[0]);
        this.buildURLs(classpath, connectionInfo);
    }

    public final void buildURLs(String classpath, DomainConnectionModel connectionInfo) throws Exception {
        Helper.logDebugMessage("Creating PluginClassLoader for " + classpath);
        StringTokenizer st = new StringTokenizer(classpath, ";");
        while (st.hasMoreTokens()) {
            String strPluginPath = st.nextToken();
            if (PluginJarFile.isValidFile(strPluginPath)) {
                PluginJarFile pluginJarFile = new PluginJarFile(strPluginPath, connectionInfo);
                JarFileCache.add(pluginJarFile);
                if (!this.isURLPresent(pluginJarFile.toURL())) {
                    this.addURL(pluginJarFile.toURL());
                }
            } else {
                File file = new File(strPluginPath);
                if (!this.isURLPresent(file.toURL())) {
                    this.addURL(file.toURL());
                }
            }
            Helper.logDebugMessage("Load of plugin from '" + strPluginPath + "' complete.");
        }
    }

    private boolean isURLPresent(URL url) {
        URL[] urls = this.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            if (urls[i] == null || !urls[i].equals(url)) continue;
            return true;
        }
        return false;
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (name.startsWith("[")) {
            clazz = Class.forName(name, false, this);
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (MgmtConsole.LOCAL_CLASSES) {
            return super.loadClass(name, resolve);
        }
        clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        try {
            clazz = this.findClass(name);
            if (clazz != null) {
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public URL getResource(String name) {
        URL result = super.findResource(name);
        if (null == result) {
            result = super.getResource(name);
        }
        return result;
    }
}

