/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.plugin;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.WorkspaceWindow;
import com.sonicsw.ma.gui.domain.DomainConnectionModel;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.plugin.ConfigContext;
import com.sonicsw.ma.plugin.ConfigFactoryInfo;
import com.sonicsw.ma.plugin.EditorInfo;
import com.sonicsw.ma.plugin.IConfigContext;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.IRuntimeContext;
import com.sonicsw.ma.plugin.IToolExtension;
import com.sonicsw.ma.plugin.MFLibraryMap;
import com.sonicsw.ma.plugin.PluginAttributes;
import com.sonicsw.ma.plugin.PluginClassLoader;
import com.sonicsw.ma.plugin.RuntimeContext;
import com.sonicsw.ma.plugin.RuntimeFactoryInfo;
import com.sonicsw.ma.plugin.ToolInfo;
import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public class PluginContext
implements IPluginContext {
    private static final String ELEMENT_ID_JMS = "JMS";
    private static final String ELEMENT_ID_SOAP = "SOAP";
    private static final String ELEMENT_ID_DIRECT = "DIRECT";
    private static final String MF_LIBRARY_BASE = "/_MFLibrary/";
    private static final String MF_LIBRARY_PLUGINS = new String("/_MFLibrary/") + "plugins";
    private static final String MF_LIBRARY_TOOLS = new String("/_MFLibrary/") + "tools";
    private static final String MF_LIBRARY_EDITORS = new String("/_MFLibrary/") + "editors";
    private static final String MF_LIBRARY_EXTENSIONS = new String("/_MFLibrary/") + "extensions";
    private static final AttributeName AN_PLUGIN_CONFIG = new AttributeName("CONFIG_PLUGIN_FACTORY_CLASS");
    private static final AttributeName AN_PLUGIN_RUNTIME = new AttributeName("RUNTIME_PLUGIN_FACTORY_CLASS");
    private static final AttributeName AN_PLUGIN_CLASSPATH = new AttributeName("PLUGIN_FACTORY_CLASSPATH");
    private static final AttributeName AN_TOOL_NAME = new AttributeName("NAME");
    private static final AttributeName AN_TOOL_DESC = new AttributeName("DESCRIPTION");
    private static final AttributeName AN_TOOL_CLASS = new AttributeName("CLASS");
    private static final AttributeName AN_TOOL_CLASSPATH = new AttributeName("CLASSPATH");
    private static final AttributeName AN_TOOL_APP = new AttributeName("APP");
    private static final AttributeName AN_TOOL_CONFIGURE = new AttributeName("CONFIGURE");
    private static final AttributeName AN_EDITOR_EXTENSION = new AttributeName("EXTENSION");
    private static final AttributeName AN_EDITOR_DESC = new AttributeName("DESCRIPTION");
    private static final AttributeName AN_EDITOR_CLASS = new AttributeName("CLASS");
    private static final AttributeName AN_EDITOR_CLASSPATH = new AttributeName("CLASSPATH");
    private static final AttributeName AN_TOOL_EXTENSION_DESC = new AttributeName("DESCRIPTION");
    private static final AttributeName AN_TOOL_EXTENSION_CLASSNAME = new AttributeName("CLASSNAME");
    private static final AttributeName AN_TOOL_EXTENSION_CLASSPATH = new AttributeName("CLASSPATH");
    private boolean m_destroy = false;
    private IRuntimeContext m_runtimeContext;
    private IConfigContext m_configContext;
    private DomainConnectionModel m_connectionInfo;
    private WorkspaceWindow m_workspace;
    private MFLibraryMap m_library = new MFLibraryMap();

    public PluginContext(DomainConnectionModel connectionInfo) {
        this.m_connectionInfo = connectionInfo;
    }

    @Override
    public IConfigContext getConfigContext() {
        return this.m_configContext;
    }

    @Override
    public IRuntimeContext getRuntimeContext() {
        return this.m_runtimeContext;
    }

    @Override
    public DomainConnectionModel getConnectionInfo() {
        return this.m_connectionInfo;
    }

    @Override
    public MgmtConsole getMgmtConsole() {
        return MgmtConsole.getMgmtConsole();
    }

    @Override
    public MFLibraryMap getLibrary() {
        return this.m_library;
    }

    @Override
    public WorkspaceWindow getWorkspace() {
        return this.m_workspace;
    }

    public void setWorkspace(WorkspaceWindow workspace) {
        this.m_workspace = workspace;
    }

    @Override
    public void create() throws Exception {
        this.m_connectionInfo.connect();
        if (this.m_destroy) {
            return;
        }
        this.m_runtimeContext = new RuntimeContext(this);
        this.m_configContext = new ConfigContext(this);
        this.initPluginFactoryMap();
        this.initToolsMap();
        this.initEditorsMap();
        this.initToolExtensions();
    }

    @Override
    public void destroy() {
        this.m_destroy = true;
        this.m_workspace = null;
        this.m_library = null;
        this.m_runtimeContext = null;
        this.m_configContext = null;
    }

    private void initPluginFactoryMap() throws Exception {
        IDirectoryAdminService dsp = (IDirectoryAdminService)this.getConnectionInfo().getDirectoryService();
        IDirElement[] element = dsp.getAllElements(MF_LIBRARY_PLUGINS, false);
        for (int i = 0; i < element.length; ++i) {
            if (this.m_destroy) {
                return;
            }
            try {
                String config = (String)element[i].getAttribute(AN_PLUGIN_CONFIG);
                String runtime = (String)element[i].getAttribute(AN_PLUGIN_RUNTIME);
                String classpath = (String)element[i].getAttribute(AN_PLUGIN_CLASSPATH);
                ClassLoader cl = null;
                cl = classpath != null && classpath.length() != 0 ? new PluginClassLoader(classpath, this.m_connectionInfo) : this.getClass().getClassLoader();
                if (config != null) {
                    this.addConfigFactory(config, cl, element[i]);
                }
                if (runtime == null) continue;
                this.addRuntimeFactory(runtime, cl, element[i]);
                continue;
            }
            catch (Throwable e) {
                this.getMgmtConsole().notifyMessage(3, "Could not load plugin factory: " + (String)element[i].getAttribute(AN_PLUGIN_CLASSPATH), e, true);
            }
        }
    }

    private void initToolsMap() throws Exception {
        IDirectoryAdminService dsp = (IDirectoryAdminService)this.getConnectionInfo().getDirectoryService();
        IDirElement[] element = dsp.getAllElements(MF_LIBRARY_TOOLS, false);
        for (int i = 0; i < element.length; ++i) {
            if (this.m_destroy) {
                return;
            }
            try {
                String name = (String)element[i].getAttribute(AN_TOOL_NAME);
                String desc = (String)element[i].getAttribute(AN_TOOL_DESC);
                String app = (String)element[i].getAttribute(AN_TOOL_APP);
                String cls = (String)element[i].getAttribute(AN_TOOL_CLASS);
                String classpath = (String)element[i].getAttribute(AN_TOOL_CLASSPATH);
                Boolean config = (Boolean)element[i].getAttribute(AN_TOOL_CONFIGURE);
                ClassLoader cl = null;
                cl = classpath != null && classpath.length() != 0 ? new PluginClassLoader(classpath, this.m_connectionInfo) : this.getClass().getClassLoader();
                this.m_library.addToolInfo(ToolInfo.createInfo(this, cl, name, desc, app, cls, config != null ? config : false));
                continue;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }

    private void initEditorsMap() throws Exception {
        try {
            IDirectoryAdminService dsp = (IDirectoryAdminService)this.getConnectionInfo().getDirectoryService();
            IDirElement[] element = dsp.getAllElements(MF_LIBRARY_EDITORS, false);
            for (int i = 0; i < element.length; ++i) {
                if (this.m_destroy) {
                    return;
                }
                try {
                    ArrayList<String> extns = new ArrayList<String>();
                    StringTokenizer tn = new StringTokenizer(((String)element[i].getAttribute(AN_EDITOR_EXTENSION)).trim(), ",", false);
                    while (tn.hasMoreTokens()) {
                        extns.add(tn.nextToken().trim());
                    }
                    String desc = (String)element[i].getAttribute(AN_EDITOR_DESC);
                    String cls = (String)element[i].getAttribute(AN_EDITOR_CLASS);
                    String classpath = (String)element[i].getAttribute(AN_EDITOR_CLASSPATH);
                    ClassLoader cl = null;
                    cl = classpath != null && classpath.length() != 0 ? new PluginClassLoader(classpath, this.m_connectionInfo) : this.getClass().getClassLoader();
                    Iterator it = extns.iterator();
                    while (it.hasNext()) {
                        this.m_library.addEditorInfo(new EditorInfo(this, cl, (String)it.next(), desc, cls));
                    }
                    continue;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addConfigFactory(String className, ClassLoader cl, IDirElement element) {
        try {
            ConfigFactoryInfo info = new ConfigFactoryInfo(className, cl, element);
            this.m_library.addConfigRootFactoryInfo(info);
            PluginAttributes attributes = info.getRootFactory().getAttributes();
            StringBuffer msg = new StringBuffer("Loaded config factory for ");
            msg.append(attributes.getDisplayType());
            msg.append(" (product=");
            msg.append(attributes.getProductVersionsString());
            msg.append(" config=");
            msg.append(attributes.getConfigVersion());
            msg.append(" build=");
            msg.append(attributes.getPluginRevision());
            msg.append(")");
            this.getMgmtConsole().notifyMessage(2, msg.toString(), false);
        }
        catch (Throwable e) {
            this.getMgmtConsole().notifyMessage(4, "Failed to load configuration factory for " + className, e, false);
        }
    }

    private void addRuntimeFactory(String className, ClassLoader cl, IDirElement element) {
        try {
            RuntimeFactoryInfo info = new RuntimeFactoryInfo(className, cl, element);
            this.m_library.addRuntimeRootFactoryInfo(info);
            PluginAttributes attributes = info.getRootFactory().getAttributes();
            StringBuffer msg = new StringBuffer("Loaded runtime factory for ");
            msg.append(attributes.getDisplayType());
            msg.append(" (product=");
            msg.append(attributes.getProductVersionsString());
            msg.append(" config=");
            msg.append(attributes.getConfigVersion());
            msg.append(" build=");
            msg.append(attributes.getPluginRevision());
            msg.append(")");
            this.getMgmtConsole().notifyMessage(2, msg.toString(), false);
        }
        catch (Throwable e) {
            this.getMgmtConsole().notifyMessage(4, "Failed to load runtime factory for " + className, e, false);
        }
    }

    private void initToolExtensions() throws Exception {
        try {
            IDirectoryAdminService dsp = (IDirectoryAdminService)this.getConnectionInfo().getDirectoryService();
            IDirElement[] element = dsp.getAllElements(MF_LIBRARY_EXTENSIONS, false);
            for (int i = 0; i < element.length; ++i) {
                if (this.m_destroy) {
                    return;
                }
                try {
                    String desc = (String)element[i].getAttribute(AN_TOOL_EXTENSION_DESC);
                    String classname = (String)element[i].getAttribute(AN_TOOL_EXTENSION_CLASSNAME);
                    String classpath = (String)element[i].getAttribute(AN_TOOL_EXTENSION_CLASSPATH);
                    ClassLoader cl = null;
                    cl = classpath != null && classpath.length() != 0 ? new PluginClassLoader(classpath, this.m_connectionInfo) : this.getClass().getClassLoader();
                    Helper.logDebugMessage("Loading Tool Extension: " + desc + " (" + classname + ")");
                    IToolExtension ext = (IToolExtension)Class.forName(classname, true, cl).newInstance();
                    ext.init(this);
                    continue;
                }
                catch (Throwable e) {
                    this.getMgmtConsole().notifyMessage(4, "Failed to load tool extension ", e, false);
                }
            }
        }
        catch (Exception e) {
            this.getMgmtConsole().notifyMessage(4, "Failed to load tool extensions ", e, false);
        }
    }
}

