/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.plugin;

import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.util.JRowTable;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.ma.plugin.IPlugin;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class PluginDnd
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    public static final DataFlavor FLAVOR_PLUGIN = new DataFlavor(IConfigPlugin.class, "Sonic SMC Configuration Plugin");
    private Component m_comp;

    public PluginDnd(Component comp) {
        this.m_comp = comp;
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this.m_comp, 0x40000000, this);
        new DropTarget(this.m_comp, 0x40000000, this);
        if (this.m_comp instanceof JTable) {
            JScrollPane sp = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this.m_comp);
            new DropTarget(sp, 0x40000000, this);
        }
    }

    protected void setCursor(DragSourceContext context, int dragAction, boolean allowed) {
        switch (dragAction) {
            case 1: 
            case 3: {
                context.setCursor(allowed ? DragSource.DefaultCopyDrop : DragSource.DefaultCopyNoDrop);
                break;
            }
            case 2: {
                context.setCursor(allowed ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop);
                break;
            }
            case 0x40000000: {
                context.setCursor(allowed ? DragSource.DefaultLinkDrop : DragSource.DefaultLinkNoDrop);
            }
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent evt) {
        Object obj;
        JTree dragComp;
        TreePath dragPath;
        Point dragPos = evt.getDragOrigin();
        IPlugin dragPlugin = null;
        if (evt.getComponent() instanceof JRowTable) {
            JRowTable dragComp2 = (JRowTable)evt.getComponent();
            int dragRow = dragComp2.rowAtPoint(dragPos);
            if (dragRow >= 0 && dragComp2.isRowSelected(dragRow)) {
                dragPlugin = (IPlugin)((IModelTableModel)dragComp2.getModel()).getRowModel(dragRow);
            }
        } else if (evt.getComponent() instanceof JTree && (dragPath = (dragComp = (JTree)evt.getComponent()).getPathForLocation(dragPos.x, dragPos.y)) != null && (obj = dragPath.getLastPathComponent()) instanceof IPlugin) {
            dragPlugin = (IPlugin)obj;
        }
        if (dragPlugin != null && dragPlugin instanceof IConfigPlugin && ((IConfigPlugin)dragPlugin).isDragSupported(0x40000000)) {
            evt.startDrag(DragSource.DefaultLinkNoDrop, new PluginTransferable(dragPlugin), this);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent evt) {
    }

    @Override
    public void dragExit(DragSourceEvent evt) {
        this.setCursor(evt.getDragSourceContext(), evt.getDragSourceContext().getTrigger().getDragAction(), false);
    }

    @Override
    public void dragOver(DragSourceDragEvent evt) {
        this.setCursor(evt.getDragSourceContext(), evt.getDropAction(), true);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent evt) {
        this.dragOver(evt);
    }

    @Override
    public void dragEnter(DragSourceDragEvent evt) {
        this.dragOver(evt);
    }

    @Override
    public void drop(DropTargetDropEvent evt) {
        int errCode = 0;
        IConfigPlugin dropPlugin = null;
        IConfigPlugin dragPlugin = null;
        try {
            if (evt.isDataFlavorSupported(FLAVOR_PLUGIN)) {
                Point point;
                JRowTable table;
                int row;
                DropTargetContext context = evt.getDropTargetContext();
                if (context.getComponent() instanceof JTree) {
                    Object obj;
                    JTree tree = (JTree)context.getComponent();
                    Point point2 = evt.getLocation();
                    TreePath path = tree.getPathForLocation(point2.x, point2.y);
                    if (path != null && (obj = path.getLastPathComponent()) instanceof IConfigPlugin) {
                        dropPlugin = (IConfigPlugin)obj;
                    }
                } else if (context.getComponent() instanceof JRowTable && (row = (table = (JRowTable)context.getComponent()).rowAtPoint(point = evt.getLocation())) >= 0) {
                    dropPlugin = (IConfigPlugin)((IModelTableModel)table.getModel()).getRowModel(row);
                }
            }
            if ((dragPlugin = (IConfigPlugin)evt.getTransferable().getTransferData(FLAVOR_PLUGIN)) != null && dropPlugin != null && dragPlugin != dropPlugin && dropPlugin.isDropSupported(evt.getDropAction())) {
                evt.acceptDrop(evt.getDropAction());
                dropPlugin.drop(dragPlugin, evt.getDropAction());
            } else {
                errCode = -1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            errCode = 1;
        }
        if (errCode == -1) {
            evt.rejectDrop();
        } else {
            evt.dropComplete(errCode == 0);
        }
    }

    @Override
    public void dragExit(DropTargetEvent evt) {
    }

    @Override
    public void dragOver(DropTargetDragEvent evt) {
        boolean allowed;
        DropTargetContext context = evt.getDropTargetContext();
        IConfigPlugin dropPlugin = null;
        try {
            Point point;
            JRowTable table;
            int row;
            if (context.getComponent() instanceof JTree) {
                Object obj;
                JTree tree = (JTree)context.getComponent();
                Point point2 = evt.getLocation();
                TreePath path = tree.getPathForLocation(point2.x, point2.y);
                if (path != null && (obj = path.getLastPathComponent()) instanceof IConfigPlugin) {
                    dropPlugin = (IConfigPlugin)obj;
                }
            } else if (context.getComponent() instanceof JRowTable && (row = (table = (JRowTable)context.getComponent()).rowAtPoint(point = evt.getLocation())) >= 0) {
                dropPlugin = (IConfigPlugin)((IModelTableModel)table.getModel()).getRowModel(row);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean bl = allowed = dropPlugin != null && dropPlugin.isDropSupported(evt.getDropAction());
        if (allowed) {
            evt.acceptDrag(evt.getDropAction());
        } else {
            evt.rejectDrag();
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent evt) {
        this.dragOver(evt);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent evt) {
        this.dragOver(evt);
    }

    class PluginTransferable
    implements Transferable,
    ClipboardOwner {
        private IPlugin m_plugin;

        public PluginTransferable(IPlugin plugin) {
            this.m_plugin = plugin;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{FLAVOR_PLUGIN};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            DataFlavor[] supported = this.getTransferDataFlavors();
            for (int i = 0; i < supported.length; ++i) {
                if (!flavor.equals(supported[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!flavor.equals(FLAVOR_PLUGIN)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.m_plugin;
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }
}

