/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.plugin;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.domain.DomainConnectionModel;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.plugin.JarFileCache;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigBeanFile;
import com.sonicsw.mx.config.IConfigElement;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;

public class PluginJarFile
extends File {
    private static final String SONICFS_PREFIX = "sonicfs://";
    private static final String DRIVE_SEPARATOR = ":/";
    private static final String[] EXTENSIONS = new String[]{".jar", ".zip"};
    private String m_strOriginalPluginPath = null;
    private DomainConnectionModel m_connectionInfo = null;
    private boolean m_bInUse = false;

    public PluginJarFile(String strPluginPath, DomainConnectionModel connectionInfo) throws Exception {
        super(PluginJarFile.convertToCacheFilename(strPluginPath, connectionInfo));
        this.m_strOriginalPluginPath = strPluginPath;
        this.m_connectionInfo = connectionInfo;
    }

    public static boolean hasSonicFSPath(String strPluginPath) {
        return strPluginPath.startsWith(SONICFS_PREFIX);
    }

    public static boolean isValidFile(String strPluginPath) {
        if (PluginJarFile.hasSonicFSPath(strPluginPath)) {
            for (int i = 0; i < EXTENSIONS.length; ++i) {
                if (!strPluginPath.endsWith(EXTENSIONS[i])) continue;
                return true;
            }
        }
        return false;
    }

    public String getRelativePath() {
        String strRelativePath = null;
        if (PluginJarFile.hasSonicFSPath(this.m_strOriginalPluginPath)) {
            strRelativePath = this.m_strOriginalPluginPath.substring(SONICFS_PREFIX.length());
        } else {
            Helper.logErrorMessage("PluginJarFile is not sonicfs: type.");
        }
        return strRelativePath;
    }

    public String getOriginalPluginPath() {
        return this.m_strOriginalPluginPath;
    }

    private static String convertToCacheFilename(String strPluginPath, DomainConnectionModel connectionInfo) throws MalformedURLException {
        if (!PluginJarFile.hasSonicFSPath(strPluginPath)) {
            throw new MalformedURLException("Invalid file path: " + strPluginPath);
        }
        String strLocalFilename = strPluginPath.substring(SONICFS_PREFIX.length());
        return JarFileCache.getCachePath() + File.separator + String.valueOf(connectionInfo.getUniqueId()) + strLocalFilename;
    }

    protected boolean needsUpdating() throws ConfigServiceException {
        boolean bNeedsUpdating = true;
        if (this.isCached() && this.m_connectionInfo.getConfigServer() != null) {
            IConfigBean dsFile = (IConfigBean)this.m_connectionInfo.getConfigServer().loadConfigElement(this.getRelativePath());
            if (dsFile == null) {
                return false;
            }
            long localModified = this.lastModified();
            long dsModified = (Long)dsFile.getAttribute("LAST_MODIFIED_TIME");
            bNeedsUpdating = dsModified > localModified;
        }
        return bNeedsUpdating;
    }

    protected boolean isCached() {
        return this.exists();
    }

    protected void cacheFile() throws Exception {
        this.getParentFile().mkdirs();
        this.exportFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportFile() throws Exception {
        block8: {
            OutputStream os = null;
            InputStream is = null;
            JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());
            String relativePath = this.getRelativePath();
            MgmtConsole.getMgmtConsole().notifyMessage(1, "Writing " + relativePath + " into plugin cache...", false);
            try {
                int length;
                IConfigElement element = this.m_connectionInfo.getConfigServer().loadConfigElement(relativePath);
                IConfigBeanFile bean = (IConfigBeanFile)element;
                if (bean == null) {
                    throw new Exception("File '" + relativePath + "' not found in DS.");
                }
                is = bean.getContents();
                if (is == null) break block8;
                os = new FileOutputStream(this);
                byte[] buffer = new byte[1000];
                while ((length = is.read(buffer)) != -1) {
                    ((FileOutputStream)os).write(buffer, 0, length);
                }
            }
            finally {
                if (os != null) {
                    os.flush();
                    ((FileOutputStream)os).close();
                }
                if (is != null) {
                    is.close();
                }
                wc.release();
            }
        }
    }
}

