/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.plugin;

import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.IRuntimeContext;
import com.sonicsw.ma.plugin.IRuntimePluginFactory;
import com.sonicsw.mf.common.config.query.From;
import com.sonicsw.mf.common.config.query.FromElementType;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigServer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class RuntimeContext
implements IRuntimeContext {
    private IPluginContext m_pluginContext;
    private ArrayList m_runtimeList;

    public RuntimeContext(IPluginContext context) throws Exception {
        this.m_pluginContext = context;
    }

    @Override
    public IRemoteMBeanServer getMBeanServer() {
        return this.m_pluginContext.getConnectionInfo().getMBeanServer();
    }

    @Override
    public IRuntimePluginFactory getPluginFactory(String type, String cVersion, String pVersion) {
        return this.m_pluginContext.getLibrary().getChildRuntimePluginFactory(type, cVersion, pVersion);
    }

    private ArrayList queryRuntimeRootElements() {
        if (this.m_runtimeList != null) {
            return this.m_runtimeList;
        }
        ArrayList<String> list = new ArrayList<String>();
        IConfigServer server = this.m_pluginContext.getConfigContext().getConfigServer();
        Query query = new Query();
        String[] types = this.m_pluginContext.getLibrary().getRootRuntimePluginTypes();
        for (int i = 0; i < types.length; ++i) {
            try {
                Set set = server.listConfigElements(query.setFrom((From)new FromElementType(types[i])));
                if (set == null || set.isEmpty()) continue;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    list.add((String)iterator.next());
                }
                continue;
            }
            catch (ConfigServiceException e) {
                e.printStackTrace();
            }
        }
        this.m_runtimeList = list;
        return this.m_runtimeList;
    }

    @Override
    public boolean isRuntimePath(String path) {
        ArrayList list = this.queryRuntimeRootElements();
        if (list.contains(path)) {
            return true;
        }
        for (String aPath : list) {
            if (!aPath.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addRuntimePath(String path) {
        ArrayList list = this.queryRuntimeRootElements();
        if (!list.contains(path)) {
            list.add(path);
        }
    }
}

