/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.plugin;

import com.sonicsw.ma.plugin.IPluginFactory;
import com.sonicsw.ma.plugin.IRuntimePluginFactory;
import com.sonicsw.ma.plugin.PluginAttributes;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import java.util.HashMap;

public class RuntimeFactoryInfo {
    private ClassLoader m_classLoader;
    private IRuntimePluginFactory m_rootFactory;
    private HashMap m_childFactories = new HashMap();

    public RuntimeFactoryInfo(String className, ClassLoader classLoader, IDirElement element) throws Exception {
        this.m_classLoader = classLoader;
        this.m_rootFactory = (IRuntimePluginFactory)Class.forName(className, true, this.m_classLoader).newInstance();
        this.m_rootFactory.init(element);
        this.recurseChildren(this.m_rootFactory);
    }

    public IRuntimePluginFactory getRootFactory() {
        return this.m_rootFactory;
    }

    public HashMap getChildFactoryMap() {
        return this.m_childFactories;
    }

    public IRuntimePluginFactory getChildFactory(String type, String cVersion, String pVersion) {
        if (cVersion == null || cVersion.equals(this.m_rootFactory.getAttributes().getConfigVersion())) {
            IRuntimePluginFactory factory = (IRuntimePluginFactory)this.m_childFactories.get(type);
            if (pVersion == null) {
                return factory;
            }
            if (factory != null) {
                String[] versions = factory.getAttributes().getProductVersions();
                for (int i = 0; i < versions.length; ++i) {
                    if (!versions[i].equals(pVersion)) continue;
                    return factory;
                }
            }
        }
        return null;
    }

    private void recurseChildren(IRuntimePluginFactory factory) {
        IPluginFactory[] children = factory.getChildFactories();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            IRuntimePluginFactory child = (IRuntimePluginFactory)children[i];
            PluginAttributes attributes = child.getAttributes();
            if (!this.m_childFactories.containsKey(attributes.getType())) {
                this.m_childFactories.put(attributes.getType(), child);
            }
            this.recurseChildren(child);
        }
    }
}

