/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.plugin;

import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import com.sonicsw.ma.plugin.ClasspathToolInfo;
import com.sonicsw.ma.plugin.CommandLineToolInfo;
import com.sonicsw.ma.plugin.IPluginContext;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;

public abstract class ToolInfo {
    protected IPluginContext m_context;
    protected String m_name;
    protected Integer m_mnemonic;
    protected String m_description;
    protected boolean m_configure;

    protected ToolInfo() {
    }

    public final void commonInit(IPluginContext context, String name, String description, boolean configure) {
        int mIndex;
        this.m_context = context;
        this.m_name = name;
        this.m_description = description;
        this.m_configure = configure;
        if (name != null && (mIndex = name.indexOf(38)) >= 0) {
            this.m_name = name.substring(0, mIndex) + name.substring(mIndex + 1);
            this.m_mnemonic = new Integer(name.charAt(mIndex + 1));
        }
    }

    public Object getKey() {
        return this.m_name;
    }

    public JMenuItem getMenuItem() {
        return new JBasicMenuItem(new ToolAction());
    }

    public abstract boolean canEnable();

    public abstract void execute();

    public static ToolInfo createInfo(IPluginContext context, ClassLoader classloader, String name, String desc, String app, String cls, boolean config) {
        ToolInfo tool = null;
        tool = cls != null ? new ClasspathToolInfo(context, name, desc, cls, classloader, config) : new CommandLineToolInfo(context, name, desc, app, null, config);
        return tool;
    }

    class ToolAction
    extends BasicGuiAction {
        public ToolAction() {
            super((String)null);
            this.putProperties();
        }

        private void putProperties() {
            this.putValue("Name", ToolInfo.this.m_name);
            this.putValue("ShortDescription", ToolInfo.this.m_description);
            this.putValue("LongDescription", ToolInfo.this.m_description);
            this.putValue("MnemonicKey", ToolInfo.this.m_mnemonic);
        }

        @Override
        public boolean isEnabled() {
            return ToolInfo.this.canEnable();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ToolInfo.this.execute();
        }
    }
}

