/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.util;

import com.sonicsw.ma.util.FileTrackerHandler;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FileTracker {
    private static FileTracker _tracker = null;
    private static final long INTERVAL = 2000L;
    private Map m_map = new HashMap();
    private FileTrackerThread m_thread = new FileTrackerThread();

    public FileTracker() throws Exception {
        this.m_thread.setDaemon(true);
        this.m_thread.setPriority(1);
        this.m_thread.start();
    }

    public boolean _add(FileTrackerHandler handler) {
        if (handler.getFile().exists()) {
            System.err.println("FileTracker::add '" + handler.getFile() + "'");
            this.m_map.put(handler.getFile(), handler);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileTrackerHandler _remove(File file) {
        if (file == null) {
            return null;
        }
        System.err.println("FileTracker::remove '" + file + "'");
        FileTrackerHandler handler = (FileTrackerHandler)this.m_map.remove(file);
        if (this.m_map == null || !this.m_map.isEmpty()) return handler;
        this.m_thread.setStop(true);
        Class<FileTracker> clazz = FileTracker.class;
        synchronized (FileTracker.class) {
            _tracker = null;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean add(FileTrackerHandler handler) {
        if (handler == null || handler.getFile() == null) {
            return false;
        }
        Class<FileTracker> clazz = FileTracker.class;
        synchronized (FileTracker.class) {
            if (_tracker == null) {
                try {
                    _tracker = new FileTracker();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _tracker != null ? _tracker._add(handler) : false;
        }
    }

    public static synchronized FileTrackerHandler remove(File path) {
        return _tracker == null ? null : _tracker._remove(path);
    }

    public static FileTrackerHandler remove(FileTrackerHandler handler) {
        return FileTracker.remove(handler != null ? handler.getFile() : null);
    }

    private class FileTrackerThread
    extends Thread {
        private boolean m_stop;

        public FileTrackerThread() {
            super("File Tracker");
            this.m_stop = false;
        }

        public void setStop(boolean state) {
            this.m_stop = state;
        }

        @Override
        public void run() {
            System.err.println("FileTracker::thread starting");
            try {
                while (!this.m_stop) {
                    Iterator i = FileTracker.this.m_map.values().iterator();
                    while (i.hasNext() && !this.m_stop) {
                        FileTrackerHandler handler = (FileTrackerHandler)i.next();
                        if (!handler.getFile().exists()) {
                            handler.fileDeleted();
                            continue;
                        }
                        if (!handler.isModified()) continue;
                        handler.fileModified();
                    }
                    FileTrackerThread.sleep(2000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.err.println("FileTracker::thread stopped");
        }
    }
}

