/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.util;

import java.io.File;

public abstract class FileTrackerHandler {
    private File m_file;
    private long m_lastModified;

    public FileTrackerHandler(File file) {
        this.setFile(file);
    }

    final void setFile(File file) {
        this.m_file = file;
        this.m_lastModified = this.m_file != null ? this.m_file.lastModified() : -1L;
    }

    public File getFile() {
        return this.m_file;
    }

    public boolean isModified() {
        long old = this.m_lastModified;
        this.m_lastModified = this.m_file.lastModified();
        return old != this.m_lastModified;
    }

    public void fileDeleted() {
    }

    public void fileModified() {
    }

    public void fileFinished(int exitCode) {
        if (exitCode == 0 && this.isModified()) {
            this.fileModified();
        }
    }
}

