/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework;

import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.ViewValueConverter;

public class BooleanToStringConverter
implements ViewValueConverter {
    private String falseString;
    private String trueString;
    private boolean caseSensitive;

    public BooleanToStringConverter() {
        this("false", "true", false);
    }

    public BooleanToStringConverter(String falseString, String trueString) {
        this(falseString, trueString, false);
    }

    public BooleanToStringConverter(String falseString, String trueString, boolean caseSensitive) {
        this.falseString = falseString;
        this.trueString = trueString;
        this.caseSensitive = caseSensitive;
    }

    @Override
    public String[] getViewStringValues() {
        return new String[]{this.falseString, this.trueString};
    }

    @Override
    public Class getModelClass() {
        return Boolean.class;
    }

    @Override
    public Class getViewClass() {
        return String.class;
    }

    public String getTrueString() {
        return this.trueString;
    }

    public void setTrueString(String val) {
        this.trueString = val;
    }

    public String getFalseString() {
        return this.falseString;
    }

    public void setFalseString(String val) {
        this.falseString = val;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean val) {
        this.caseSensitive = val;
    }

    @Override
    public Object viewValueToModel(Object viewValue) throws ViewValueConversionException {
        if (viewValue instanceof String) {
            String val = (String)viewValue;
            if (this.caseSensitive) {
                if (val.equals(this.trueString)) {
                    return Boolean.TRUE;
                }
                if (val.equals(this.falseString)) {
                    return Boolean.FALSE;
                }
            } else {
                if (val.equalsIgnoreCase(this.trueString)) {
                    return Boolean.TRUE;
                }
                if (val.equalsIgnoreCase(this.falseString)) {
                    return Boolean.FALSE;
                }
            }
        }
        throw new ViewValueConversionException("value not " + this.falseString + " or " + this.trueString);
    }

    @Override
    public Object modelValueToView(Object modelValue) throws ViewValueConversionException {
        if (modelValue == null) {
            modelValue = Boolean.FALSE;
        }
        if (modelValue instanceof Boolean) {
            return modelValue.equals(Boolean.TRUE) ? this.trueString : this.falseString;
        }
        throw new ViewValueConversionException("value not boolean");
    }

    @Override
    public boolean isViewValueToModelSupported() {
        return true;
    }
}

