/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import modelobjects.framework.EditForm;
import modelobjects.framework.ModelEditEvent;
import modelobjects.framework.ModelEditEventSupport;
import modelobjects.framework.ModelEditFailureEvent;
import modelobjects.framework.ModelEditFailureListener;
import modelobjects.framework.ModelEditFailureSupport;
import modelobjects.framework.ModelEditListener;
import modelobjects.framework.ModelEditMediator;
import modelobjects.framework.ModelObjectFactory;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.model.ModelObjectAdapter;
import modelobjects.framework.model.NoSuchAspectException;
import modelobjects.util.swing.RelayAction;

public class EditFormManager
implements PropertyChangeListener,
VetoableChangeListener,
ModelEditListener,
ModelEditFailureListener {
    public static final String ACTIVE_EDIT_FORM_PROPERTY = "activeEditForm";
    private ModelObjectFactory modelObjectFactory;
    private Class modelObjectType;
    private EditForm activeEditForm;
    private HashMap editFormMap;
    private RelayAction applyAction;
    private RelayAction resetAction;
    private RelayAction undoAction;
    private RelayAction redoAction;
    private Action newInstanceAction;
    private PropertyChangeSupport propertyChangeSupport;
    private VetoableChangeSupport vetoableChangeSupport;
    private ModelEditEventSupport modelEditEventSupport;
    private ModelEditFailureSupport modelEditFailureSupport;

    public EditFormManager(ModelObjectFactory modelObjectFactory) {
        this.modelObjectFactory = modelObjectFactory;
        this.modelObjectType = modelObjectFactory.getModelObjectType();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.vetoableChangeSupport = new VetoableChangeSupport(this);
        this.modelEditEventSupport = new ModelEditEventSupport(this);
        this.modelEditFailureSupport = new ModelEditFailureSupport(this);
        this.editFormMap = new HashMap();
        this.applyAction = new RelayAction();
        this.resetAction = new RelayAction();
        this.undoAction = new RelayAction();
        this.redoAction = new RelayAction();
        this.newInstanceAction = new NewInstanceAction();
    }

    public void addEditForm(EditForm editForm) {
        if (editForm.getModelDescriptor().getModelType() != this.modelObjectType) {
            String message = "EditForm's model type does not match EditFormManager's";
            throw new IllegalArgumentException(message);
        }
        this.editFormMap.put(editForm.getEditTypeKey(), editForm);
        if (this.activeEditForm == null) {
            this.activateEditForm(editForm);
        }
    }

    public void removeEditForm(EditForm editForm) {
        if (editForm == this.activeEditForm) {
            this.activateEditForm(null);
        }
        this.editFormMap.remove(editForm.getEditTypeKey());
    }

    public Object getEditTypeKey(Object modelObject) {
        return this.modelObjectType;
    }

    protected void reportError(Exception error) {
        error.printStackTrace();
    }

    public ModelObjectFactory getModelObjectFactory() {
        return this.modelObjectFactory;
    }

    public Class getModelObjectType() {
        return this.modelObjectType;
    }

    public EditForm getActiveEditForm() {
        return this.activeEditForm;
    }

    public EditForm getEditForm(Object editTypeKey) {
        return (EditForm)this.editFormMap.get(editTypeKey);
    }

    public EditForm editModelObject(Object modelObject, Object editTypeKey) throws PropertyVetoException, ViewValueConversionException, NoSuchAspectException {
        EditForm editForm = this.getEditForm(editTypeKey);
        if (editForm == null) {
            String msg = "no EditForm registered with edit-type key " + editTypeKey;
            throw new IllegalArgumentException(msg);
        }
        this.activateEditForm(editForm);
        ModelObjectAdapter modelObjectAdapter = modelObject == null ? null : editForm.getModelDescriptor().makeModelObjectAdapter(modelObject);
        editForm.editModelObject(modelObjectAdapter);
        return editForm;
    }

    public EditForm editModelAsNewObject(Object modelObject, Object editTypeKey) throws PropertyVetoException, ViewValueConversionException, NoSuchAspectException {
        EditForm editForm = this.getEditForm(editTypeKey);
        if (editForm == null) {
            String msg = "no EditForm registered with edit-type key " + editTypeKey;
            throw new IllegalArgumentException(msg);
        }
        this.activateEditForm(editForm);
        ModelObjectAdapter modelObjectAdapter = modelObject == null ? null : editForm.getModelDescriptor().makeModelObjectAdapter(modelObject);
        editForm.editModelAsNewObject(modelObjectAdapter);
        return editForm;
    }

    public EditForm createAndEditNewInstance() throws InstantiationException, IllegalAccessException, ExceptionInInitializerError, PropertyVetoException, ViewValueConversionException, NoSuchAspectException {
        Object newInstance = this.modelObjectFactory.createNewInstance();
        if (newInstance != null) {
            Object editTypeKey = this.getEditTypeKey(newInstance);
            return this.editModelAsNewObject(newInstance, editTypeKey);
        }
        return this.activeEditForm;
    }

    public synchronized void discardEdit() {
        if (this.activeEditForm != null) {
            this.activeEditForm.discardEdit();
        }
    }

    public ModelObjectAdapter getModelObjectAdapter() {
        if (this.activeEditForm == null) {
            return null;
        }
        return this.activeEditForm.getModel();
    }

    public boolean getEditModelAsNewObject() {
        if (this.activeEditForm == null) {
            return false;
        }
        return this.activeEditForm.getEditModelAsNewObject();
    }

    public boolean hasUnappliedChanges() {
        if (this.activeEditForm == null) {
            return false;
        }
        return this.activeEditForm.hasUnappliedChanges();
    }

    public void recomputeEditability() throws NoSuchAspectException {
        if (this.activeEditForm != null) {
            this.activeEditForm.recomputeEditability();
        }
    }

    public Object getCurrentModelAspectValue(ModelAspectId modelAspectId) throws ViewValueConversionException, NoSuchAspectException {
        if (this.activeEditForm == null) {
            return null;
        }
        return this.activeEditForm.getCurrentModelAspectValue(modelAspectId);
    }

    public Object getCurrentViewAspectValue(ModelAspectId modelAspectId) throws ViewValueConversionException, NoSuchAspectException {
        if (this.activeEditForm == null) {
            return null;
        }
        return this.activeEditForm.getCurrentViewAspectValue(modelAspectId);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String propName = propertyChangeEvent.getPropertyName();
        if (propName.equals("hasUnappliedChanges")) {
            this.newInstanceAction.setEnabled(this.activeEditForm != null && !this.activeEditForm.hasUnappliedChanges());
        }
        this.propertyChangeSupport.firePropertyChange(propName, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    @Override
    public void vetoableChange(PropertyChangeEvent vetoableChangeEvent) throws PropertyVetoException {
        this.vetoableChangeSupport.fireVetoableChange(vetoableChangeEvent.getPropertyName(), vetoableChangeEvent.getOldValue(), vetoableChangeEvent.getNewValue());
    }

    @Override
    public void modelEdited(ModelEditEvent event) {
        this.modelEditEventSupport.fireModelEdited(event);
    }

    @Override
    public void modelCreated(ModelEditEvent event) {
        this.modelEditEventSupport.fireModelCreated(event);
    }

    @Override
    public void modelDeleted(ModelEditEvent event) {
        this.modelEditEventSupport.fireModelDeleted(event);
    }

    @Override
    public void modelEditFailed(ModelEditFailureEvent event) {
        this.modelEditFailureSupport.fireModelEditFailure(event);
    }

    public Action getApplyAction() {
        return this.applyAction;
    }

    public Action getResetAction() {
        return this.resetAction;
    }

    public Action getUndoAction() {
        return this.undoAction;
    }

    public Action getRedoAction() {
        return this.redoAction;
    }

    public Action getNewInstanceAction() {
        return this.newInstanceAction;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport.removeVetoableChangeListener(listener);
    }

    public void addModelEditListener(ModelEditListener listener) {
        this.modelEditEventSupport.addModelEditListener(listener);
    }

    public void removeModelEditListener(ModelEditListener listener) {
        this.modelEditEventSupport.removeModelEditListener(listener);
    }

    public void addModelEditFailureListener(ModelEditFailureListener listener) {
        this.modelEditFailureSupport.addModelEditFailureListener(listener);
    }

    public void removeModelEditFailureListener(ModelEditFailureListener listener) {
        this.modelEditFailureSupport.removeModelEditFailureListener(listener);
    }

    private void activateEditForm(EditForm editForm) {
        if (editForm == this.activeEditForm) {
            return;
        }
        EditForm oldEditForm = this.activeEditForm;
        if (this.activeEditForm != null) {
            try {
                this.activeEditForm.editModelObject(null);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.activeEditForm.removePropertyChangeListener(this);
            this.activeEditForm.removeVetoableChangeListener(this);
            this.activeEditForm.removeModelEditListener(this);
            this.activeEditForm.removeModelEditFailureListener(this);
        }
        if (editForm != null) {
            editForm.addPropertyChangeListener(this);
            editForm.addVetoableChangeListener(this);
            editForm.addModelEditListener(this);
            editForm.addModelEditFailureListener(this);
            ModelEditMediator m = editForm.getModelEditMediator();
            this.applyAction.setTargetAction(m.getApplyAction());
            this.resetAction.setTargetAction(m.getResetAction());
            this.undoAction.setTargetAction(m.getUndoAction());
            this.redoAction.setTargetAction(m.getRedoAction());
        } else {
            this.applyAction.setTargetAction(null);
            this.resetAction.setTargetAction(null);
            this.undoAction.setTargetAction(null);
            this.redoAction.setTargetAction(null);
        }
        this.newInstanceAction.setEnabled(editForm != null);
        this.activeEditForm = editForm;
        this.propertyChangeSupport.firePropertyChange(ACTIVE_EDIT_FORM_PROPERTY, oldEditForm, this.activeEditForm);
    }

    class NewInstanceAction
    extends AbstractAction {
        public NewInstanceAction() {
            super("New");
        }

        private void putNameProperty() {
            if (EditFormManager.this.modelObjectFactory.isCreationInteractive()) {
                this.putValue("Name", "New...");
            }
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                EditFormManager.this.createAndEditNewInstance();
            }
            catch (Exception e) {
                EditFormManager.this.reportError(e);
            }
        }
    }
}

