/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.ViewValueConverter;

public class LongDateToStringConverter
implements ViewValueConverter {
    private static final int ITEM_DAYS = 0;
    private static final int ITEM_HOURS = 1;
    private static final int ITEM_MINUTES = 2;
    boolean m_allowNull;
    boolean m_uptime;
    DateFormat m_dateFormat;
    String m_msgFormat;

    public LongDateToStringConverter() {
        this(true, DateFormat.getDateTimeInstance());
    }

    public LongDateToStringConverter(boolean allowNull, DateFormat dateFormat) {
        this.setNullAllowed(allowNull);
        this.setDateFormat(dateFormat);
    }

    public LongDateToStringConverter(boolean uptime, String msgFormat) {
        this(true, (DateFormat)null);
        this.setProperties(uptime, msgFormat);
    }

    private void setProperties(boolean uptime, String msgFormat) {
        this.setUptimeMode(uptime);
        this.setMsgFormat(msgFormat);
    }

    public final void setNullAllowed(boolean allowNull) {
        this.m_allowNull = allowNull;
    }

    public boolean isNullAllowed() {
        return this.m_allowNull;
    }

    public final void setDateFormat(DateFormat dateFormat) {
        this.m_dateFormat = dateFormat;
    }

    public DateFormat getDateFormat() {
        return this.m_dateFormat;
    }

    public void setMsgFormat(String msgFormat) {
        this.m_msgFormat = msgFormat;
    }

    public String getMsgFormat() {
        return this.m_msgFormat;
    }

    public void setUptimeMode(boolean uptime) {
        this.m_uptime = uptime;
    }

    public boolean isUptimeMode() {
        return this.m_uptime;
    }

    @Override
    public Object viewValueToModel(Object viewValue) throws ViewValueConversionException {
        Long res = null;
        if (viewValue instanceof String) {
            if (this.isNullAllowed() && (viewValue == null || viewValue.equals(""))) {
                res = new Long(0L);
            } else {
                String stringValue = (String)viewValue;
                res = new Long(0L);
            }
        } else {
            throw new ViewValueConversionException("expected a string");
        }
        return res;
    }

    @Override
    public Object modelValueToView(Object modelValue) throws ViewValueConversionException {
        String res = null;
        if (modelValue instanceof Long) {
            long longValue = (Long)modelValue;
            if (longValue != 0L) {
                if (this.isUptimeMode()) {
                    Integer[] args = new Integer[3];
                    long tmp = longValue / 1000L;
                    args[2] = new Integer((int)((tmp /= 60L) % 60L));
                    args[1] = new Integer((int)((tmp /= 60L) % 24L));
                    args[0] = new Integer((int)(tmp /= 24L));
                    res = new MessageFormat(this.getMsgFormat()).format(args);
                } else {
                    res = this.getDateFormat().format(new Date(longValue));
                }
            }
        } else {
            throw new ViewValueConversionException(modelValue + " is not an acceptable type");
        }
        return res;
    }

    @Override
    public String[] getViewStringValues() {
        return null;
    }

    @Override
    public boolean isViewValueToModelSupported() {
        return true;
    }

    @Override
    public Class getModelClass() {
        return Long.class;
    }

    @Override
    public Class getViewClass() {
        return String.class;
    }
}

