/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;
import modelobjects.framework.EditRule;
import modelobjects.framework.ModelEditEventSupport;
import modelobjects.framework.ModelEditFailureListener;
import modelobjects.framework.ModelEditFailureSupport;
import modelobjects.framework.ModelEditListener;
import modelobjects.framework.UndoableModelAspectEdit;
import modelobjects.framework.UndoableModelEdit;
import modelobjects.framework.ViewAspectAdapter;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.model.ModelAspectAdapter;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.model.ModelDescriptor;
import modelobjects.framework.model.ModelObjectAdapter;
import modelobjects.framework.model.ModelValidationException;
import modelobjects.framework.model.NoSuchAspectException;
import modelobjects.util.WrapperRuntimeException;
import modelobjects.util.undo.CannotDoException;

public class ModelEditMediator
implements ChangeListener,
UndoableEditListener {
    public static final String MODEL_OBJECT_PROPERTY = "modelObject";
    public static final String HAS_UNAPPLIED_CHANGES_PROPERTY = "hasUnappliedChanges";
    private Action applyAction = new ApplyAction();
    private Action resetAction = new ResetAction();
    private Action undoAction = new UndoAction();
    private Action redoAction = new RedoAction();
    private HashMap viewAspectAdapterMap;
    private ModelObjectAdapter modelObjectAdapter;
    private UndoManager objectEdits;
    private UndoManager fieldEdits;
    private WeakHashMap savedUndoHistory;
    protected boolean editModelAsNewObject;
    private PropertyChangeSupport propertyChangeSupport;
    private VetoableChangeSupport vetoableChangeSupport;
    private UndoableEditSupport undoableEditSupport;
    private ModelEditEventSupport modelEditEventSupport;
    private ModelEditFailureSupport modelEditFailureSupport;
    protected HashSet aspectChanges;
    protected HashSet allAspects;
    protected transient boolean settingModel;
    protected transient boolean inUndoOrRedo;
    private boolean isValidating;

    public ModelEditMediator() {
        this.applyAction.setEnabled(false);
        this.resetAction.setEnabled(false);
        this.undoAction.setEnabled(false);
        this.redoAction.setEnabled(false);
        this.viewAspectAdapterMap = new HashMap();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.vetoableChangeSupport = new VetoableChangeSupport(this);
        this.undoableEditSupport = new UndoableEditSupport(this);
        this.modelEditEventSupport = new ModelEditEventSupport(this);
        this.modelEditFailureSupport = new ModelEditFailureSupport(this);
        this.aspectChanges = new HashSet();
        this.allAspects = new HashSet();
        this.savedUndoHistory = new WeakHashMap();
        this.objectEdits = new UndoManager();
        this.fieldEdits = null;
        this.addUndoableEditListener(this);
    }

    public synchronized void addViewAspectAdapter(ViewAspectAdapter viewAspectAdapter) {
        ModelAspectId modelAspectId = viewAspectAdapter.getModelAspectId();
        this.allAspects.add(modelAspectId);
        this.viewAspectAdapterMap.put(modelAspectId, viewAspectAdapter);
        viewAspectAdapter.addChangeListener(this);
        viewAspectAdapter.addUndoableEditListener(this);
    }

    public synchronized void removeViewAspectAdapter(ViewAspectAdapter viewAspectAdapter) {
        ModelAspectId modelAspectId = viewAspectAdapter.getModelAspectId();
        this.allAspects.remove(modelAspectId);
        this.viewAspectAdapterMap.remove(modelAspectId);
        viewAspectAdapter.removeChangeListener(this);
    }

    public ViewAspectAdapter getViewAspectAdapter(ModelAspectId modelAspectId) {
        return (ViewAspectAdapter)this.viewAspectAdapterMap.get(modelAspectId);
    }

    private ModelAspectAdapter getModelAspectAdapter(ModelAspectId aspectId) {
        ModelDescriptor descriptor = this.modelObjectAdapter.getModelDescriptor();
        ModelAspectAdapter[] adapter = descriptor.getModelAspectAdapters();
        for (int i = 0; i < adapter.length; ++i) {
            if (!adapter[i].getModelAspectId().equals(aspectId)) continue;
            return adapter[i];
        }
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (this.settingModel) {
            return;
        }
        ViewAspectAdapter source = (ViewAspectAdapter)event.getSource();
        this.aspectChanges.add(source.getModelAspectId());
        this.enableApplyAndReset(true);
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent event) {
        if (this.inUndoOrRedo) {
            return;
        }
        if (event.getSource() == this) {
            this.discardFieldEdits();
            this.objectEdits.addEdit(event.getEdit());
        } else {
            if (this.fieldEdits == null) {
                this.fieldEdits = new UndoManager();
            }
            this.fieldEdits.addEdit(event.getEdit());
        }
        this.undoAction.setEnabled(true);
    }

    public ModelObjectAdapter getModel() {
        return this.modelObjectAdapter;
    }

    public boolean getEditModelAsNewObject() {
        return this.editModelAsNewObject;
    }

    public void editModelObject(ModelObjectAdapter model) throws PropertyVetoException, ViewValueConversionException, NoSuchAspectException {
        this.editModel(model, false);
    }

    public void editModelAsNewObject(ModelObjectAdapter model) throws PropertyVetoException, ViewValueConversionException, NoSuchAspectException {
        this.editModel(model, true);
    }

    private void editModel(ModelObjectAdapter newModel, boolean editAsNew) throws PropertyVetoException, ViewValueConversionException, NoSuchAspectException {
        ModelObjectAdapter oldModel = this.modelObjectAdapter;
        boolean oldModelWasNew = this.editModelAsNewObject;
        PropertyChangeEvent propChangeEvent = new PropertyChangeEvent(this, MODEL_OBJECT_PROPERTY, oldModel, newModel);
        this.vetoableChangeSupport.fireVetoableChange(propChangeEvent);
        this.setModelInternal(newModel, editAsNew);
        Object modelObject = newModel == null ? null : newModel.getModelObject();
        UndoManager undoManager = this.objectEdits = editAsNew || modelObject == null ? null : (UndoManager)this.savedUndoHistory.get(modelObject);
        if (this.objectEdits == null) {
            this.objectEdits = new UndoManager();
        }
        this.enableApplyAndReset(false);
        this.enableUndoAndRedo();
        this.propertyChangeSupport.firePropertyChange(propChangeEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setModelInternal(ModelObjectAdapter model, boolean editAsNew) throws ViewValueConversionException, NoSuchAspectException {
        if (this.isValidating) {
            return;
        }
        try {
            this.settingModel = true;
            this.modelObjectAdapter = model;
            this.editModelAsNewObject = editAsNew;
            this.setViewFromModel(model);
        }
        finally {
            this.discardFieldEdits();
            this.enableApplyAndReset(false);
            this.settingModel = false;
        }
    }

    private synchronized void setViewFromModel(ModelObjectAdapter model) throws ViewValueConversionException, NoSuchAspectException {
        this.aspectChanges.clear();
        for (ModelAspectId modelAspectId : this.viewAspectAdapterMap.keySet()) {
            ViewAspectAdapter viewAspectAdapter = (ViewAspectAdapter)this.viewAspectAdapterMap.get(modelAspectId);
            Object modelAspectValue = model == null ? null : model.getAspectValue(modelAspectId);
            viewAspectAdapter.setModelAspectValue(modelAspectValue);
            EditRule editRule = viewAspectAdapter.getEditRule();
            boolean editable = model != null && !model.isReadonlyAspect(modelAspectId) && (editRule == null || editRule.isEditableInEditor(viewAspectAdapter, this));
            viewAspectAdapter.setEditable(editable);
        }
    }

    public void recomputeEditability() throws NoSuchAspectException {
        ModelObjectAdapter model = this.getModel();
        for (ModelAspectId modelAspectId : this.viewAspectAdapterMap.keySet()) {
            ViewAspectAdapter viewAspectAdapter = (ViewAspectAdapter)this.viewAspectAdapterMap.get(modelAspectId);
            EditRule editRule = viewAspectAdapter.getEditRule();
            boolean editable = model != null && !model.isReadonlyAspect(modelAspectId) && (editRule == null || editRule.isEditableInEditor(viewAspectAdapter, this));
            viewAspectAdapter.setEditable(editable);
        }
    }

    public Object getCurrentModelAspectValue(ModelAspectId modelAspectId) throws ViewValueConversionException, NoSuchAspectException {
        ViewAspectAdapter viewAspectAdapter = (ViewAspectAdapter)this.viewAspectAdapterMap.get(modelAspectId);
        return viewAspectAdapter.getModelAspectValue();
    }

    public Object getCurrentViewAspectValue(ModelAspectId modelAspectId) throws ViewValueConversionException, NoSuchAspectException {
        ViewAspectAdapter viewAspectAdapter = (ViewAspectAdapter)this.viewAspectAdapterMap.get(modelAspectId);
        return viewAspectAdapter.getViewAspectValue();
    }

    public Action getApplyAction() {
        return this.applyAction;
    }

    public Action getResetAction() {
        return this.resetAction;
    }

    public Action getUndoAction() {
        return this.undoAction;
    }

    public Action getRedoAction() {
        return this.redoAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void apply() throws NoSuchAspectException, ViewValueConversionException, PropertyVetoException, CannotDoException, ModelValidationException {
        UndoableModelAspectEdit[] aspectEdits = null;
        aspectEdits = this.collectAspectEdits();
        PropertyChangeEvent[] propertyChangeEvents = this.getPropertyChangeEvents(aspectEdits);
        int n = propertyChangeEvents.length;
        for (int i = 0; i < n; ++i) {
            this.vetoableChangeSupport.fireVetoableChange(propertyChangeEvents[i]);
        }
        UndoableModelEdit compoundModelEdit = new UndoableModelEdit("modify model", this.modelObjectAdapter);
        boolean succeeded = false;
        boolean wasNew = this.editModelAsNewObject;
        Object model = this.modelObjectAdapter.getModelObject();
        Throwable failureException = null;
        try {
            for (UndoableModelAspectEdit aspectEdit : aspectEdits) {
                aspectEdit.doEdit(false);
                compoundModelEdit.addEdit(aspectEdit);
            }
            this.enableApplyAndReset(false);
            this.editModelAsNewObject = false;
            this.isValidating = true;
            if (wasNew) {
                this.modelObjectAdapter.validateNewModel();
                this.modelObjectAdapter.propagateModelCreation();
                this.modelEditEventSupport.fireModelCreated(2, model);
            } else {
                this.modelObjectAdapter.validateModel();
                this.modelObjectAdapter.propagateModelEdit();
                this.modelEditEventSupport.fireModelEdited(2, model);
            }
            succeeded = true;
        }
        catch (Throwable e) {
            failureException = e;
        }
        finally {
            this.isValidating = false;
            compoundModelEdit.end();
        }
        if (!succeeded) {
            this.editModelAsNewObject = wasNew;
            this.enableApplyAndReset(true);
            try {
                compoundModelEdit.undo();
            }
            catch (Exception errorInUndo) {
                System.err.println("ERROR: Cannot undo failed apply: " + errorInUndo);
            }
        } else {
            this.setModelInternal(this.modelObjectAdapter, false);
            int n2 = propertyChangeEvents.length;
            for (int i = 0; i < n2; ++i) {
                this.propertyChangeSupport.firePropertyChange(propertyChangeEvents[i]);
            }
            if (!wasNew) {
                this.undoableEditSupport.postEdit(compoundModelEdit);
            }
            this.savedUndoHistory.put(model, this.objectEdits);
        }
        if (failureException != null) {
            if (failureException instanceof NoSuchAspectException) {
                throw (NoSuchAspectException)failureException;
            }
            if (failureException instanceof PropertyVetoException) {
                throw (PropertyVetoException)failureException;
            }
            if (failureException instanceof CannotDoException) {
                throw (CannotDoException)failureException;
            }
            if (failureException instanceof ModelValidationException) {
                throw (ModelValidationException)failureException;
            }
            throw new ModelValidationException(failureException);
        }
    }

    public synchronized void reset() throws ViewValueConversionException, NoSuchAspectException {
        this.setModelInternal(this.modelObjectAdapter, this.editModelAsNewObject);
        this.enableApplyAndReset(false);
    }

    public synchronized void discardEdit() {
        try {
            if (this.editModelAsNewObject) {
                this.setModelInternal(null, false);
            } else {
                this.setModelInternal(this.modelObjectAdapter, this.editModelAsNewObject);
            }
            this.enableApplyAndReset(false);
        }
        catch (Exception e) {
            throw new WrapperRuntimeException(e);
        }
    }

    private UndoableModelAspectEdit[] collectAspectEdits() throws ViewValueConversionException {
        int numChangedAspects = this.editModelAsNewObject ? this.allAspects.size() : this.aspectChanges.size();
        HashSet aspectIds = this.editModelAsNewObject ? this.allAspects : this.aspectChanges;
        ArrayList<UndoableModelAspectEdit> collector = new ArrayList<UndoableModelAspectEdit>(numChangedAspects);
        Iterator aspects = aspectIds.iterator();
        int i = 0;
        while (aspects.hasNext()) {
            UndoableModelAspectEdit aspectEdit;
            ModelAspectId aspectId = (ModelAspectId)aspects.next();
            ViewAspectAdapter viewAspectAdapter = this.getViewAspectAdapter(aspectId);
            ModelAspectAdapter modelAspectAdapter = this.getModelAspectAdapter(aspectId);
            if ((viewAspectAdapter.isEditable() || this.aspectChanges.contains(aspectId)) && !modelAspectAdapter.isReadonlyAspect() && (aspectEdit = viewAspectAdapter.makeUndoableModelAspectEdit(this.modelObjectAdapter)) != null) {
                collector.add(aspectEdit);
            }
            ++i;
        }
        UndoableModelAspectEdit[] edits = new UndoableModelAspectEdit[collector.size()];
        collector.toArray(edits);
        return edits;
    }

    private PropertyChangeEvent[] getPropertyChangeEvents(UndoableModelAspectEdit[] aspectEdits) {
        int numEdits = aspectEdits.length;
        PropertyChangeEvent[] result = new PropertyChangeEvent[numEdits];
        for (int i = 0; i < numEdits; ++i) {
            result[i] = aspectEdits[i].getPropertyChangeEvent();
        }
        return result;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport.removeVetoableChangeListener(listener);
    }

    public final void addUndoableEditListener(UndoableEditListener listener) {
        this.undoableEditSupport.addUndoableEditListener(listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.undoableEditSupport.removeUndoableEditListener(listener);
    }

    public void addModelEditListener(ModelEditListener listener) {
        this.modelEditEventSupport.addModelEditListener(listener);
    }

    public void removeModelEditListener(ModelEditListener listener) {
        this.modelEditEventSupport.removeModelEditListener(listener);
    }

    public void addModelEditFailureListener(ModelEditFailureListener listener) {
        this.modelEditFailureSupport.addModelEditFailureListener(listener);
    }

    public void removeModelEditFailureListener(ModelEditFailureListener listener) {
        this.modelEditFailureSupport.removeModelEditFailureListener(listener);
    }

    private void discardFieldEdits() {
        if (this.fieldEdits != null) {
            this.fieldEdits.end();
            this.fieldEdits = null;
        }
    }

    private void enableUndoAndRedo() {
        boolean canUndo = this.objectEdits.canUndo() || this.fieldEdits != null && this.fieldEdits.canUndo();
        boolean canRedo = this.objectEdits.canRedo() || this.fieldEdits != null && this.fieldEdits.canRedo();
        this.undoAction.setEnabled(canUndo);
        this.redoAction.setEnabled(canRedo);
    }

    private void enableApplyAndReset(boolean enabled) {
        boolean wasEnabled = this.applyAction.isEnabled();
        boolean enableApply = enabled || this.editModelAsNewObject;
        this.applyAction.setEnabled(enableApply);
        this.resetAction.setEnabled(enabled);
        if (wasEnabled != enableApply) {
            PropertyChangeEvent propChangeEvent = new PropertyChangeEvent(this, HAS_UNAPPLIED_CHANGES_PROPERTY, new Boolean(wasEnabled), new Boolean(enableApply));
            this.propertyChangeSupport.firePropertyChange(propChangeEvent);
        }
    }

    public boolean hasUnappliedChanges() {
        return this.resetAction.isEnabled();
    }

    private class RedoAction
    extends AbstractAction {
        RedoAction() {
            super("Redo");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                ModelEditMediator.this.inUndoOrRedo = true;
                if (ModelEditMediator.this.objectEdits.canRedo()) {
                    ModelEditMediator.this.objectEdits.redo();
                    ModelEditMediator.this.reset();
                    ModelEditMediator.this.modelObjectAdapter.validateModel();
                    ModelEditMediator.this.modelObjectAdapter.propagateModelEdit();
                    Object model = ModelEditMediator.this.modelObjectAdapter.getModelObject();
                    ModelEditMediator.this.modelEditEventSupport.fireModelEdited(4, model);
                } else if (ModelEditMediator.this.fieldEdits != null && ModelEditMediator.this.fieldEdits.canRedo()) {
                    ModelEditMediator.this.fieldEdits.redo();
                } else {
                    System.out.println("ERROR: cannot really redo anything!");
                }
                ModelEditMediator.this.enableUndoAndRedo();
            }
            catch (Exception e) {
                Object model = ModelEditMediator.this.modelObjectAdapter.getModelObject();
                ModelEditMediator.this.modelEditFailureSupport.fireModelEditFailure(model, e);
                System.err.println("Error in redo: " + e);
            }
            finally {
                ModelEditMediator.this.inUndoOrRedo = false;
            }
        }
    }

    private class UndoAction
    extends AbstractAction {
        UndoAction() {
            super("Undo");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                ModelEditMediator.this.inUndoOrRedo = true;
                if (ModelEditMediator.this.fieldEdits != null && ModelEditMediator.this.fieldEdits.canUndo()) {
                    ModelEditMediator.this.fieldEdits.undo();
                } else if (ModelEditMediator.this.objectEdits.canUndo()) {
                    ModelEditMediator.this.objectEdits.undo();
                    ModelEditMediator.this.reset();
                    ModelEditMediator.this.modelObjectAdapter.validateModel();
                    ModelEditMediator.this.modelObjectAdapter.propagateModelEdit();
                    Object model = ModelEditMediator.this.modelObjectAdapter.getModelObject();
                    ModelEditMediator.this.modelEditEventSupport.fireModelEdited(3, model);
                } else {
                    System.out.println("ERROR: cannot really undo anything!");
                }
                ModelEditMediator.this.enableUndoAndRedo();
            }
            catch (Exception e) {
                Object model = ModelEditMediator.this.modelObjectAdapter.getModelObject();
                ModelEditMediator.this.modelEditFailureSupport.fireModelEditFailure(model, e);
                System.err.println("Error in undo: " + e);
            }
            finally {
                ModelEditMediator.this.inUndoOrRedo = false;
            }
        }
    }

    private class ResetAction
    extends AbstractAction {
        ResetAction() {
            super("Reset");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                ModelEditMediator.this.reset();
            }
            catch (Exception e) {
                System.err.println("Error in reset: " + e);
                e.printStackTrace();
            }
            ModelEditMediator.this.enableUndoAndRedo();
        }
    }

    private class ApplyAction
    extends AbstractAction {
        ApplyAction() {
            super("Apply");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                ModelEditMediator.this.apply();
            }
            catch (Exception exception) {
                Object model = ModelEditMediator.this.modelObjectAdapter.getModelObject();
                ModelEditMediator.this.modelEditFailureSupport.fireModelEditFailure(model, exception);
            }
            ModelEditMediator.this.enableUndoAndRedo();
        }
    }
}

