/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework;

import java.lang.reflect.Constructor;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.ViewValueConverter;

public class NumberToStringConverter
implements ViewValueConverter {
    protected boolean m_allowNull;
    protected Class m_modelClass;

    public NumberToStringConverter(Class modelClass) {
        this(modelClass, true);
    }

    public NumberToStringConverter(Class modelClass, boolean allowNull) {
        this.m_modelClass = modelClass;
        this.m_allowNull = allowNull;
    }

    @Override
    public Object viewValueToModel(Object viewValue) throws ViewValueConversionException {
        if (viewValue instanceof String) {
            if (this.m_allowNull && (viewValue == null || viewValue.equals(""))) {
                return null;
            }
            try {
                String sval = (String)viewValue;
                Constructor c = this.m_modelClass.getConstructor(String.class);
                return c.newInstance(viewValue);
            }
            catch (Exception e) {
                throw new ViewValueConversionException("Failed to convert <" + viewValue + "> to a " + this.m_modelClass.getName());
            }
        }
        String viewType = viewValue != null ? viewValue.getClass().getName() : "null";
        throw new ViewValueConversionException(viewType + " is not an allowed type - expecting " + this.getViewClass().getName() + " (" + viewValue + ")");
    }

    @Override
    public Object modelValueToView(Object modelValue) throws ViewValueConversionException {
        if (modelValue == null) {
            return "";
        }
        return modelValue.toString();
    }

    @Override
    public String[] getViewStringValues() {
        return null;
    }

    @Override
    public boolean isViewValueToModelSupported() {
        return true;
    }

    @Override
    public Class getModelClass() {
        return this.m_modelClass;
    }

    @Override
    public Class getViewClass() {
        return String.class;
    }
}

