/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework;

import java.math.BigDecimal;
import modelobjects.framework.BigDecimalToStringConverter;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.ViewValueConverter;

public class PercentageToBigDecimalConverter
implements ViewValueConverter {
    protected BigDecimalToStringConverter m_converter;
    protected int m_scale;
    protected boolean m_allowNull;

    public PercentageToBigDecimalConverter(BigDecimalToStringConverter converter, int scale) {
        this(converter, scale, true);
    }

    public PercentageToBigDecimalConverter(BigDecimalToStringConverter converter, int scale, boolean allowNull) {
        this.m_converter = converter;
        this.m_scale = scale;
        this.m_allowNull = allowNull;
    }

    @Override
    public Object viewValueToModel(Object viewValue) throws ViewValueConversionException {
        BigDecimal value = (BigDecimal)this.m_converter.viewValueToModel(viewValue);
        if (this.m_allowNull && value == null) {
            return null;
        }
        double scaleFactor = Math.pow(10.0, this.m_scale);
        double tmp = value.doubleValue() / 100.0;
        tmp *= scaleFactor;
        tmp = (double)Math.round(tmp) / scaleFactor;
        return new BigDecimal(Double.toString(tmp));
    }

    @Override
    public Object modelValueToView(Object modelValue) throws ViewValueConversionException {
        if (modelValue == null) {
            return "";
        }
        if (modelValue instanceof BigDecimal) {
            BigDecimal value = (BigDecimal)modelValue;
            BigDecimal newValue = value.multiply(new BigDecimal(100.0));
            newValue = newValue.setScale(this.m_scale, 4);
            return this.m_converter.modelValueToView(newValue);
        }
        throw new ViewValueConversionException("Invalid modelValue type: expecting BigDecimal!");
    }

    @Override
    public String[] getViewStringValues() {
        return null;
    }

    @Override
    public boolean isViewValueToModelSupported() {
        return true;
    }

    @Override
    public Class getModelClass() {
        return BigDecimal.class;
    }

    @Override
    public Class getViewClass() {
        return String.class;
    }
}

