/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import modelobjects.framework.EditRule;
import modelobjects.framework.ModelEditMediator;
import modelobjects.framework.PropertyEditorViewValueConverter;
import modelobjects.framework.ViewAspectAdapter;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.swing.JComboBoxAdapter;
import modelobjects.framework.swing.JTextFieldAdapter;

public class PropertyEditorViewAspectAdapter
extends ViewAspectAdapter
implements PropertyChangeListener {
    private PropertyEditor propertyEditor;
    private Component viewComponent;

    public static ViewAspectAdapter makeViewAspectAdapter(ModelAspectId modelAspectId, EditRule editRule, PropertyEditor propertyEditor, ModelEditMediator mediator) {
        Component comp = propertyEditor.supportsCustomEditor() ? propertyEditor.getCustomEditor() : null;
        String[] choices = propertyEditor.getTags();
        if (comp != null) {
            PropertyEditorViewAspectAdapter aspectAdapter = new PropertyEditorViewAspectAdapter(modelAspectId, editRule, propertyEditor, mediator, comp);
            return aspectAdapter;
        }
        if (choices != null) {
            JComboBox<String> comboBox = new JComboBox<String>(choices);
            PropertyEditorViewValueConverter converter = new PropertyEditorViewValueConverter(Object.class, propertyEditor);
            JComboBoxAdapter aspectAdapter = new JComboBoxAdapter(modelAspectId, comboBox, editRule, converter, mediator);
            return aspectAdapter;
        }
        JTextField textField = new JTextField(20);
        PropertyEditorViewValueConverter converter = new PropertyEditorViewValueConverter(Object.class, propertyEditor);
        JTextFieldAdapter aspectAdapter = new JTextFieldAdapter(modelAspectId, textField, editRule, converter, mediator);
        return aspectAdapter;
    }

    private PropertyEditorViewAspectAdapter(ModelAspectId modelAspectId, EditRule editRule, PropertyEditor propertyEditor, ModelEditMediator mediator, Component viewComponent) {
        super(modelAspectId, editRule, null, mediator);
        this.propertyEditor = propertyEditor;
        this.viewComponent = viewComponent;
        propertyEditor.addPropertyChangeListener(this);
    }

    @Override
    public Component getViewComponent() {
        return this.viewComponent;
    }

    @Override
    public boolean isEditable() {
        return this.viewComponent.isEnabled();
    }

    @Override
    public void setEditable(boolean val) {
        this.viewComponent.setEnabled(val);
    }

    @Override
    public Object getViewAspectValue() {
        return this.propertyEditor.getValue();
    }

    @Override
    public String getViewAspectStringValue() {
        return this.propertyEditor.getAsText();
    }

    @Override
    protected void setViewAspectValue(Object viewAspectValue) throws IllegalArgumentException {
        this.propertyEditor.setValue(viewAspectValue);
    }

    @Override
    public void setViewAspectStringValue(String stringValue) {
        this.propertyEditor.setAsText(stringValue);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.fireChangeEvent();
    }

    public static void main(String[] args) {
        PropertyEditor boolEditor = PropertyEditorManager.findEditor(Boolean.TYPE);
        System.out.println("bolean editor = " + boolEditor);
        if (boolEditor == null) {
            boolEditor = PropertyEditorManager.findEditor(Boolean.class);
            System.out.println("second try - boolean editor = " + boolEditor);
        }
        if (boolEditor != null) {
            ModelAspectId aspectId = ModelAspectId.forName("Foo");
            ViewAspectAdapter viewAspectAdapter = PropertyEditorViewAspectAdapter.makeViewAspectAdapter(aspectId, EditRule.ALWAYS, boolEditor, null);
            System.out.println("aspect adapter = " + viewAspectAdapter);
        }
        System.exit(0);
    }
}

