/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework;

import java.beans.PropertyEditor;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.ViewValueConverter;

public class PropertyEditorViewValueConverter
implements ViewValueConverter {
    private Class modelClass;
    private PropertyEditor propertyEditor;

    public PropertyEditorViewValueConverter(Class modelClass, PropertyEditor propertyEditor) {
        this.modelClass = modelClass;
        this.propertyEditor = propertyEditor;
    }

    @Override
    public Object viewValueToModel(Object viewValue) throws ViewValueConversionException {
        try {
            this.propertyEditor.setAsText((String)viewValue);
            return this.propertyEditor.getValue();
        }
        catch (RuntimeException rte) {
            String message = rte.getMessage();
            if (message == null || message.length() == 0) {
                message = rte.toString();
            }
            throw new ViewValueConversionException(message);
        }
    }

    @Override
    public Object modelValueToView(Object modelValue) throws ViewValueConversionException {
        try {
            this.propertyEditor.setValue(modelValue);
            return this.propertyEditor.getAsText();
        }
        catch (RuntimeException rte) {
            String message = rte.getMessage();
            if (message == null || message.length() == 0) {
                message = rte.toString();
            }
            throw new ViewValueConversionException(message);
        }
    }

    @Override
    public String[] getViewStringValues() {
        return this.propertyEditor.getTags();
    }

    @Override
    public boolean isViewValueToModelSupported() {
        return true;
    }

    @Override
    public Class getModelClass() {
        return this.modelClass;
    }

    @Override
    public Class getViewClass() {
        return String.class;
    }
}

