/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.FocusManager;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import modelobjects.framework.EditForm;
import modelobjects.framework.EditFormManager;
import modelobjects.framework.ModelEditEvent;
import modelobjects.framework.ModelEditEventSupport;
import modelobjects.framework.ModelEditFailureEvent;
import modelobjects.framework.ModelEditFailureListener;
import modelobjects.framework.ModelEditFailureSupport;
import modelobjects.framework.ModelEditListener;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.model.ModelObjectAdapter;
import modelobjects.util.swing.ModelListTableModel;
import modelobjects.util.swing.RelayAction;

public class TableFormMediator
implements ModelEditListener,
ListSelectionListener,
PropertyChangeListener {
    private JTable table;
    private ModelListTableModel tableModel;
    private EditFormManager formManager;
    private Object rowModelInForm;
    private Action deleteRowAction;
    private RelayAction newInstanceAction;
    private boolean hasPendingEdits;
    private ModelEditEventSupport modelEditEventSupport;
    private ModelEditFailureSupport modelEditFailureSupport;

    public TableFormMediator(final JTable table, EditFormManager formManager) {
        this.table = table;
        this.tableModel = (ModelListTableModel)table.getModel();
        this.formManager = formManager;
        this.modelEditEventSupport = new ModelEditEventSupport(this);
        this.modelEditFailureSupport = new ModelEditFailureSupport(this);
        formManager.addModelEditListener(this);
        table.getSelectionModel().addListSelectionListener(this);
        formManager.addPropertyChangeListener(this);
        this.newInstanceAction = new RelayAction(formManager.getNewInstanceAction()){

            @Override
            public void actionPerformed(ActionEvent event) {
                table.clearSelection();
                super.actionPerformed(event);
                SwingUtilities.invokeLater(new FocusOnForm());
            }
        };
        this.deleteRowAction = new DeleteRowAction();
        this.enableActions();
    }

    public void addModelEditListener(ModelEditListener listener) {
        this.modelEditEventSupport.addModelEditListener(listener);
    }

    public void removeModelEditListener(ModelEditListener listener) {
        this.modelEditEventSupport.removeModelEditListener(listener);
    }

    public void addModelEditFailureListener(ModelEditFailureListener listener) {
        this.modelEditFailureSupport.addModelEditFailureListener(listener);
    }

    public void removeModelEditFailureListener(ModelEditFailureListener listener) {
        this.modelEditFailureSupport.removeModelEditFailureListener(listener);
    }

    public Action getDeleteRowAction() {
        return this.deleteRowAction;
    }

    public Action getNewInstanceAction() {
        return this.newInstanceAction;
    }

    protected boolean handleUnappliedChanges() {
        System.out.println("Apply or reset changes first!");
        return false;
    }

    protected void revertTableSelection() {
        if (this.rowModelInForm != null) {
            int index = this.tableModel.getIndexOf(this.rowModelInForm);
            this.table.setRowSelectionInterval(index, index);
        } else {
            this.table.clearSelection();
        }
    }

    public boolean confirmDelete(Object modelObject) {
        return true;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting() || this.table.getSelectionModel().getValueIsAdjusting()) {
            return;
        }
        try {
            int numSelectedRows = this.table.getSelectedRowCount();
            if (numSelectedRows != 1) {
                this.rowModelInForm = null;
                EditForm activeForm = this.formManager.getActiveEditForm();
                if (activeForm != null) {
                    this.formManager.editModelObject(null, activeForm.getEditTypeKey());
                }
            } else {
                int row = this.table.getSelectedRow();
                if (row >= 0 && row < this.tableModel.getRowCount()) {
                    Object rowModel = this.tableModel.getRowModel(row);
                    if (rowModel == this.rowModelInForm) {
                        return;
                    }
                    if (!this.formManager.hasUnappliedChanges() || this.handleUnappliedChanges()) {
                        this.rowModelInForm = rowModel;
                        Object editTypeKey = this.formManager.getEditTypeKey(rowModel);
                        this.formManager.editModelObject(rowModel, editTypeKey);
                    } else {
                        this.revertTableSelection();
                    }
                }
            }
        }
        catch (PropertyVetoException e) {
            this.revertTableSelection();
        }
        catch (ViewValueConversionException e) {
            this.revertTableSelection();
        }
        this.enableActions();
    }

    @Override
    public void modelEdited(ModelEditEvent modelEditEvent) {
        if (modelEditEvent.getObjectWasNew()) {
            this.modelCreated(modelEditEvent);
        } else {
            this.tableModel.rowChanged(this.table.getSelectedRow());
            this.modelEditEventSupport.fireModelEdited(modelEditEvent);
        }
    }

    @Override
    public void modelCreated(ModelEditEvent modelEditEvent) {
        Object modelObject = modelEditEvent.getModelObject();
        int row = this.tableModel.getIndexOf(modelObject);
        if (row < 0) {
            this.tableModel.insertRowMaintainSort(modelObject);
        } else {
            this.tableModel.rowChanged(row);
        }
        row = this.tableModel.getIndexOf(modelObject);
        this.table.setRowSelectionInterval(row, row);
        this.modelEditEventSupport.fireModelCreated(modelEditEvent);
    }

    @Override
    public void modelDeleted(ModelEditEvent modelEditEvent) {
        this.modelEditEventSupport.fireModelDeleted(modelEditEvent);
    }

    public void modelEditFailed(ModelEditFailureEvent event) {
        this.modelEditFailureSupport.fireModelEditFailure(event);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object eventSource = propertyChangeEvent.getSource();
        if (eventSource == this.formManager) {
            this.hasPendingEdits = this.formManager.hasUnappliedChanges();
            this.enableActions();
        }
    }

    final void enableActions() {
        int numSelectedRows = this.table.getSelectedRowCount();
        this.deleteRowAction.setEnabled(numSelectedRows == 1 && !this.hasPendingEdits);
    }

    class FocusOnForm
    implements Runnable {
        FocusOnForm() {
        }

        @Override
        public void run() {
            Component comp = TableFormMediator.this.formManager.getActiveEditForm().getFormComponent();
            FocusManager.getCurrentManager().focusNextComponent(comp);
        }
    }

    class DeleteRowAction
    extends AbstractAction {
        public DeleteRowAction() {
            super("Delete...");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (TableFormMediator.this.table.getSelectedRowCount() == 1) {
                int row = TableFormMediator.this.table.getSelectedRow();
                Object rowModel = TableFormMediator.this.tableModel.getRowModel(row);
                if (TableFormMediator.this.confirmDelete(rowModel)) {
                    try {
                        ModelObjectAdapter rowModelAdapter = TableFormMediator.this.formManager.getModelObjectAdapter();
                        if (rowModelAdapter != null && rowModelAdapter.getModelObject() == rowModel) {
                            rowModelAdapter.validateModelDeletion();
                            rowModelAdapter.propagateModelDeletion();
                        }
                        TableFormMediator.this.modelEditEventSupport.fireModelDeleted(5, rowModel, false);
                        TableFormMediator.this.table.clearSelection();
                        TableFormMediator.this.tableModel.deleteRow(row);
                        int rowCount = TableFormMediator.this.tableModel.getRowCount();
                        if (rowCount > row) {
                            TableFormMediator.this.table.setRowSelectionInterval(row, row);
                        } else if (rowCount > 0) {
                            TableFormMediator.this.table.setRowSelectionInterval(row - 1, row - 1);
                        }
                    }
                    catch (Exception e) {
                        TableFormMediator.this.modelEditFailureSupport.fireModelEditFailure(rowModel, e);
                    }
                }
                TableFormMediator.this.enableActions();
            }
        }
    }
}

