/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.model.ModelObjectAdapter;
import modelobjects.framework.model.NoSuchAspectException;
import modelobjects.util.undo.CannotDoException;
import modelobjects.util.undo.CannotRedoException;
import modelobjects.util.undo.CannotUndoException;
import modelobjects.util.undo.DoableUndoableEdit;
import modelobjects.util.undo.PresentableUndoableEdit;

public class UndoableModelAspectEdit
extends PresentableUndoableEdit
implements DoableUndoableEdit {
    private ModelObjectAdapter modelObjectAdapter;
    private ModelAspectId modelAspectId;
    private Object oldValue;
    private Object newValue;
    private boolean alreadyDone;

    public UndoableModelAspectEdit(String presentationName, ModelObjectAdapter modelObjectAdapter, ModelAspectId modelAspectId, Object oldValue, Object newValue) {
        super(presentationName);
        this.modelObjectAdapter = modelObjectAdapter;
        this.modelAspectId = modelAspectId;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Override
    public void doEdit() throws CannotDoException {
        this.doEdit(true);
    }

    public void doEdit(boolean compareOldWithNew) throws CannotDoException {
        if (this.alreadyDone && !this.canRedo()) {
            IllegalStateException reason = new IllegalStateException("alreadyDone && canRedo() == false");
            throw new CannotDoException("doEdit", reason);
        }
        if (!compareOldWithNew || this.newValue != this.oldValue) {
            try {
                this.modelObjectAdapter.setAspectValue(this.modelAspectId, this.newValue);
            }
            catch (PropertyVetoException e) {
                throw new CannotDoException(e);
            }
            catch (NoSuchAspectException e) {
                throw new CannotDoException(e);
            }
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        if (this.newValue != this.oldValue) {
            try {
                this.modelObjectAdapter.setAspectValue(this.modelAspectId, this.oldValue);
            }
            catch (PropertyVetoException e) {
                throw new CannotUndoException(e);
            }
            catch (NoSuchAspectException e) {
                throw new CannotUndoException(e);
            }
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        if (this.newValue != this.oldValue) {
            try {
                this.modelObjectAdapter.setAspectValue(this.modelAspectId, this.newValue);
            }
            catch (PropertyVetoException e) {
                throw new CannotRedoException(e);
            }
            catch (NoSuchAspectException e) {
                throw new CannotRedoException(e);
            }
        }
    }

    public ModelAspectId getModelAspectId() {
        return this.modelAspectId;
    }

    @Override
    public void die() {
        super.die();
        this.oldValue = null;
        this.newValue = null;
    }

    public PropertyChangeEvent getPropertyChangeEvent() {
        return new PropertyChangeEvent(this.modelObjectAdapter, this.modelAspectId.getName(), this.oldValue, this.newValue);
    }
}

