/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework;

import java.beans.PropertyVetoException;
import javax.swing.undo.AbstractUndoableEdit;
import modelobjects.framework.ModelEditMediator;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.model.ModelObjectAdapter;
import modelobjects.util.undo.CannotRedoException;
import modelobjects.util.undo.CannotUndoException;

public class UndoableSetModelEdit
extends AbstractUndoableEdit {
    private String presentationName;
    private ModelEditMediator modelEditMediator;
    private ModelObjectAdapter oldModel;
    private boolean oldIsNew;
    private ModelObjectAdapter newModel;
    private boolean newIsNew;

    public UndoableSetModelEdit(String presentationName, ModelEditMediator modelEditMediator, ModelObjectAdapter oldModel, boolean oldIsNew, ModelObjectAdapter newModel, boolean newIsNew) {
        this.presentationName = presentationName;
        this.modelEditMediator = modelEditMediator;
        this.oldModel = oldModel;
        this.oldIsNew = oldIsNew;
        this.newModel = newModel;
        this.newIsNew = newIsNew;
    }

    @Override
    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            IllegalStateException reason = new IllegalStateException("canUndo == false");
            throw new CannotUndoException(this.getUndoPresentationName(), reason);
        }
        Exception undoFailure = this.flipState(this.newModel, this.newIsNew, this.oldModel, this.oldIsNew, true);
        if (undoFailure != null) {
            undoFailure.printStackTrace();
            throw new CannotUndoException(this.getUndoPresentationName(), undoFailure);
        }
        super.undo();
    }

    @Override
    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            IllegalStateException reason = new IllegalStateException("canRedo == false");
            throw new CannotRedoException(this.getRedoPresentationName(), reason);
        }
        Exception redoFailure = this.flipState(this.oldModel, this.oldIsNew, this.newModel, this.newIsNew, true);
        if (redoFailure != null) {
            throw new CannotUndoException(this.getRedoPresentationName(), redoFailure);
        }
        super.redo();
    }

    @Override
    public String getPresentationName() {
        return this.presentationName;
    }

    @Override
    public String getUndoPresentationName() {
        return "undo " + this.presentationName;
    }

    @Override
    public String getRedoPresentationName() {
        return "redo " + this.presentationName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Exception flipState(ModelObjectAdapter fromModel, boolean fromIsNew, ModelObjectAdapter toModel, boolean toIsNew, boolean isUndo) {
        boolean succeeded = false;
        Exception failure = null;
        try {
            if (toIsNew) {
                this.modelEditMediator.editModelAsNewObject(toModel);
            } else {
                this.modelEditMediator.editModelObject(toModel);
            }
            succeeded = true;
        }
        catch (PropertyVetoException veto) {
            failure = veto;
        }
        catch (ViewValueConversionException badVal) {
            failure = badVal;
        }
        finally {
            if (!succeeded) {
                try {
                    if (fromIsNew) {
                        this.modelEditMediator.editModelAsNewObject(fromModel);
                    } else {
                        this.modelEditMediator.editModelObject(fromModel);
                    }
                }
                catch (PropertyVetoException veto) {
                }
                catch (ViewValueConversionException badVal) {}
            }
        }
        return failure;
    }

    @Override
    public void die() {
        super.die();
        this.modelEditMediator = null;
        this.oldModel = null;
        this.newModel = null;
    }
}

